<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

							do_action( 'law_office_action_page_content_end_text' );
							
							// Widgets area below the content
							law_office_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'law_office_action_page_content_end' );
							?>
						</div>
						<?php

						// Show main sidebar
						get_sidebar();
						?>
					</div>
					<?php

					do_action( 'law_office_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$law_office_body_style = law_office_get_theme_option( 'body_style' );
					$law_office_widgets_name = law_office_get_theme_option( 'widgets_below_page' );
					$law_office_show_widgets = ! law_office_is_off( $law_office_widgets_name ) && is_active_sidebar( $law_office_widgets_name );
					$law_office_show_related = law_office_is_single() && law_office_get_theme_option( 'related_position' ) == 'below_page';
					if ( $law_office_show_widgets || $law_office_show_related ) {
						if ( 'fullscreen' != $law_office_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $law_office_show_related ) {
							do_action( 'law_office_action_related_posts' );
						}

						// Widgets area below page content
						if ( $law_office_show_widgets ) {
							law_office_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $law_office_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'law_office_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'law_office_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! law_office_is_singular( 'post' ) && ! law_office_is_singular( 'attachment' ) ) || ! in_array ( law_office_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="law_office_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'law_office_action_before_footer' );

				// Footer
				$law_office_footer_type = law_office_get_theme_option( 'footer_type' );
				if ( 'custom' == $law_office_footer_type && ! law_office_is_layouts_available() ) {
					$law_office_footer_type = 'default';
				}
				get_template_part( apply_filters( 'law_office_filter_get_template_part', "templates/footer-" . sanitize_file_name( $law_office_footer_type ) ) );

				do_action( 'law_office_action_after_footer' );

			}
			?>

			<?php do_action( 'law_office_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'law_office_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'law_office_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>