<?php
/**
 * The Front Page template file.
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0.31
 */

get_header();

// If front-page is a static page
if ( get_option( 'show_on_front' ) == 'page' ) {

	// If Front Page Builder is enabled - display sections
	if ( law_office_is_on( law_office_get_theme_option( 'front_page_enabled', false ) ) ) {

		if ( have_posts() ) {
			the_post();
		}

		$law_office_sections = law_office_array_get_keys_by_value( law_office_get_theme_option( 'front_page_sections' ) );
		if ( is_array( $law_office_sections ) ) {
			foreach ( $law_office_sections as $law_office_section ) {
				get_template_part( apply_filters( 'law_office_filter_get_template_part', 'front-page/section', $law_office_section ), $law_office_section );
			}
		}

		// Else if this page is blog archive
	} elseif ( is_page_template( 'blog.php' ) ) {
		get_template_part( apply_filters( 'law_office_filter_get_template_part', 'blog' ) );

		// Else - display native page content
	} else {
		get_template_part( apply_filters( 'law_office_filter_get_template_part', 'page' ) );
	}

	// Else get index template to show posts
} else {
	get_template_part( apply_filters( 'law_office_filter_get_template_part', 'index' ) );
}

get_footer();
