<div class="front_page_section front_page_section_contacts<?php
	$law_office_scheme = law_office_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $law_office_scheme ) && ! law_office_is_inherit( $law_office_scheme ) ) {
		echo ' scheme_' . esc_attr( $law_office_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( law_office_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( law_office_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$law_office_css      = '';
		$law_office_bg_image = law_office_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $law_office_bg_image ) ) {
			$law_office_css .= 'background-image: url(' . esc_url( law_office_get_attachment_url( $law_office_bg_image ) ) . ');';
		}
		if ( ! empty( $law_office_css ) ) {
			echo ' style="' . esc_attr( $law_office_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$law_office_anchor_icon = law_office_get_theme_option( 'front_page_contacts_anchor_icon' );
	$law_office_anchor_text = law_office_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $law_office_anchor_icon ) || ! empty( $law_office_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $law_office_anchor_icon ) ? ' icon="' . esc_attr( $law_office_anchor_icon ) . '"' : '' )
									. ( ! empty( $law_office_anchor_text ) ? ' title="' . esc_attr( $law_office_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( law_office_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' law-office-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$law_office_css      = '';
			$law_office_bg_mask  = law_office_get_theme_option( 'front_page_contacts_bg_mask' );
			$law_office_bg_color_type = law_office_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $law_office_bg_color_type ) {
				$law_office_bg_color = law_office_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $law_office_bg_color_type ) {
				$law_office_bg_color = law_office_get_scheme_color( 'bg_color', $law_office_scheme );
			} else {
				$law_office_bg_color = '';
			}
			if ( ! empty( $law_office_bg_color ) && $law_office_bg_mask > 0 ) {
				$law_office_css .= 'background-color: ' . esc_attr(
					1 == $law_office_bg_mask ? $law_office_bg_color : law_office_hex2rgba( $law_office_bg_color, $law_office_bg_mask )
				) . ';';
			}
			if ( ! empty( $law_office_css ) ) {
				echo ' style="' . esc_attr( $law_office_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$law_office_caption     = law_office_get_theme_option( 'front_page_contacts_caption' );
			$law_office_description = law_office_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $law_office_caption ) || ! empty( $law_office_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $law_office_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $law_office_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $law_office_caption, 'law_office_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $law_office_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $law_office_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $law_office_description ), 'law_office_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$law_office_content = law_office_get_theme_option( 'front_page_contacts_content' );
			$law_office_layout  = law_office_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $law_office_layout && ( ! empty( $law_office_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $law_office_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $law_office_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $law_office_content, 'law_office_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $law_office_layout && ( ! empty( $law_office_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$law_office_sc = law_office_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $law_office_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $law_office_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					law_office_show_layout( do_shortcode( $law_office_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $law_office_layout && ( ! empty( $law_office_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
