<div class="front_page_section front_page_section_features<?php
	$law_office_scheme = law_office_get_theme_option( 'front_page_features_scheme' );
	if ( ! empty( $law_office_scheme ) && ! law_office_is_inherit( $law_office_scheme ) ) {
		echo ' scheme_' . esc_attr( $law_office_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( law_office_get_theme_option( 'front_page_features_paddings' ) );
	if ( law_office_get_theme_option( 'front_page_features_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$law_office_css      = '';
		$law_office_bg_image = law_office_get_theme_option( 'front_page_features_bg_image' );
		if ( ! empty( $law_office_bg_image ) ) {
			$law_office_css .= 'background-image: url(' . esc_url( law_office_get_attachment_url( $law_office_bg_image ) ) . ');';
		}
		if ( ! empty( $law_office_css ) ) {
			echo ' style="' . esc_attr( $law_office_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$law_office_anchor_icon = law_office_get_theme_option( 'front_page_features_anchor_icon' );
	$law_office_anchor_text = law_office_get_theme_option( 'front_page_features_anchor_text' );
if ( ( ! empty( $law_office_anchor_icon ) || ! empty( $law_office_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_features"'
									. ( ! empty( $law_office_anchor_icon ) ? ' icon="' . esc_attr( $law_office_anchor_icon ) . '"' : '' )
									. ( ! empty( $law_office_anchor_text ) ? ' title="' . esc_attr( $law_office_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_features_inner
	<?php
	if ( law_office_get_theme_option( 'front_page_features_fullheight' ) ) {
		echo ' law-office-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$law_office_css      = '';
			$law_office_bg_mask  = law_office_get_theme_option( 'front_page_features_bg_mask' );
			$law_office_bg_color_type = law_office_get_theme_option( 'front_page_features_bg_color_type' );
			if ( 'custom' == $law_office_bg_color_type ) {
				$law_office_bg_color = law_office_get_theme_option( 'front_page_features_bg_color' );
			} elseif ( 'scheme_bg_color' == $law_office_bg_color_type ) {
				$law_office_bg_color = law_office_get_scheme_color( 'bg_color', $law_office_scheme );
			} else {
				$law_office_bg_color = '';
			}
			if ( ! empty( $law_office_bg_color ) && $law_office_bg_mask > 0 ) {
				$law_office_css .= 'background-color: ' . esc_attr(
					1 == $law_office_bg_mask ? $law_office_bg_color : law_office_hex2rgba( $law_office_bg_color, $law_office_bg_mask )
				) . ';';
			}
			if ( ! empty( $law_office_css ) ) {
				echo ' style="' . esc_attr( $law_office_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_features_content_wrap content_wrap">
			<?php
			// Caption
			$law_office_caption = law_office_get_theme_option( 'front_page_features_caption' );
			if ( ! empty( $law_office_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_features_caption front_page_block_<?php echo ! empty( $law_office_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $law_office_caption, 'law_office_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$law_office_description = law_office_get_theme_option( 'front_page_features_description' );
			if ( ! empty( $law_office_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_features_description front_page_block_<?php echo ! empty( $law_office_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $law_office_description ), 'law_office_kses_content' ); ?></div>
				<?php
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_features_output">
				<?php
				if ( is_active_sidebar( 'front_page_features_widgets' ) ) {
					dynamic_sidebar( 'front_page_features_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! law_office_exists_trx_addons() ) {
						law_office_customizer_need_trx_addons_message();
					} else {
						law_office_customizer_need_widgets_message( 'front_page_features_caption', 'ThemeREX Addons - Services' );
					}
				}
				?>
			</div>
		</div>
	</div>
</div>
