<?php
$law_office_slider_sc = law_office_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $law_office_slider_sc ) && strpos( $law_office_slider_sc, '[' ) !== false && strpos( $law_office_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( law_office_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$law_office_anchor_icon = law_office_get_theme_option( 'front_page_title_anchor_icon' );
		$law_office_anchor_text = law_office_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $law_office_anchor_icon ) || ! empty( $law_office_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $law_office_anchor_icon ) ? ' icon="' . esc_attr( $law_office_anchor_icon ) . '"' : '' )
									. ( ! empty( $law_office_anchor_text ) ? ' title="' . esc_attr( $law_office_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $law_office_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$law_office_scheme = law_office_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $law_office_scheme ) && ! law_office_is_inherit( $law_office_scheme ) ) {
			echo ' scheme_' . esc_attr( $law_office_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( law_office_get_theme_option( 'front_page_title_paddings' ) );
		if ( law_office_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$law_office_css      = '';
		$law_office_bg_image = law_office_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $law_office_bg_image ) ) {
			$law_office_css .= 'background-image: url(' . esc_url( law_office_get_attachment_url( $law_office_bg_image ) ) . ');';
		}
		if ( ! empty( $law_office_css ) ) {
			echo ' style="' . esc_attr( $law_office_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$law_office_anchor_icon = law_office_get_theme_option( 'front_page_title_anchor_icon' );
		$law_office_anchor_text = law_office_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $law_office_anchor_icon ) || ! empty( $law_office_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $law_office_anchor_icon ) ? ' icon="' . esc_attr( $law_office_anchor_icon ) . '"' : '' )
									. ( ! empty( $law_office_anchor_text ) ? ' title="' . esc_attr( $law_office_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( law_office_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' law-office-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$law_office_css      = '';
			$law_office_bg_mask  = law_office_get_theme_option( 'front_page_title_bg_mask' );
			$law_office_bg_color_type = law_office_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $law_office_bg_color_type ) {
				$law_office_bg_color = law_office_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $law_office_bg_color_type ) {
				$law_office_bg_color = law_office_get_scheme_color( 'bg_color', $law_office_scheme );
			} else {
				$law_office_bg_color = '';
			}
			if ( ! empty( $law_office_bg_color ) && $law_office_bg_mask > 0 ) {
				$law_office_css .= 'background-color: ' . esc_attr(
					1 == $law_office_bg_mask ? $law_office_bg_color : law_office_hex2rgba( $law_office_bg_color, $law_office_bg_mask )
				) . ';';
			}
			if ( ! empty( $law_office_css ) ) {
				echo ' style="' . esc_attr( $law_office_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$law_office_caption = law_office_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $law_office_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $law_office_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $law_office_caption, 'law_office_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$law_office_description = law_office_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $law_office_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $law_office_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $law_office_description ), 'law_office_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( law_office_get_theme_option( 'front_page_title_button1_link' ) != '' || law_office_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						law_office_show_layout( law_office_customizer_partial_refresh_front_page_title_button1_link() );
						law_office_show_layout( law_office_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
