<div class="front_page_section front_page_section_woocommerce<?php
	$law_office_scheme = law_office_get_theme_option( 'front_page_woocommerce_scheme' );
	if ( ! empty( $law_office_scheme ) && ! law_office_is_inherit( $law_office_scheme ) ) {
		echo ' scheme_' . esc_attr( $law_office_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( law_office_get_theme_option( 'front_page_woocommerce_paddings' ) );
	if ( law_office_get_theme_option( 'front_page_woocommerce_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$law_office_css      = '';
		$law_office_bg_image = law_office_get_theme_option( 'front_page_woocommerce_bg_image' );
		if ( ! empty( $law_office_bg_image ) ) {
			$law_office_css .= 'background-image: url(' . esc_url( law_office_get_attachment_url( $law_office_bg_image ) ) . ');';
		}
		if ( ! empty( $law_office_css ) ) {
			echo ' style="' . esc_attr( $law_office_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$law_office_anchor_icon = law_office_get_theme_option( 'front_page_woocommerce_anchor_icon' );
	$law_office_anchor_text = law_office_get_theme_option( 'front_page_woocommerce_anchor_text' );
if ( ( ! empty( $law_office_anchor_icon ) || ! empty( $law_office_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_woocommerce"'
									. ( ! empty( $law_office_anchor_icon ) ? ' icon="' . esc_attr( $law_office_anchor_icon ) . '"' : '' )
									. ( ! empty( $law_office_anchor_text ) ? ' title="' . esc_attr( $law_office_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_woocommerce_inner
	<?php
	if ( law_office_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
		echo ' law-office-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$law_office_css      = '';
			$law_office_bg_mask  = law_office_get_theme_option( 'front_page_woocommerce_bg_mask' );
			$law_office_bg_color_type = law_office_get_theme_option( 'front_page_woocommerce_bg_color_type' );
			if ( 'custom' == $law_office_bg_color_type ) {
				$law_office_bg_color = law_office_get_theme_option( 'front_page_woocommerce_bg_color' );
			} elseif ( 'scheme_bg_color' == $law_office_bg_color_type ) {
				$law_office_bg_color = law_office_get_scheme_color( 'bg_color', $law_office_scheme );
			} else {
				$law_office_bg_color = '';
			}
			if ( ! empty( $law_office_bg_color ) && $law_office_bg_mask > 0 ) {
				$law_office_css .= 'background-color: ' . esc_attr(
					1 == $law_office_bg_mask ? $law_office_bg_color : law_office_hex2rgba( $law_office_bg_color, $law_office_bg_mask )
				) . ';';
			}
			if ( ! empty( $law_office_css ) ) {
				echo ' style="' . esc_attr( $law_office_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
			<?php
			// Content wrap with title and description
			$law_office_caption     = law_office_get_theme_option( 'front_page_woocommerce_caption' );
			$law_office_description = law_office_get_theme_option( 'front_page_woocommerce_description' );
			if ( ! empty( $law_office_caption ) || ! empty( $law_office_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $law_office_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $law_office_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $law_office_caption, 'law_office_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description (text)
				if ( ! empty( $law_office_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $law_office_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $law_office_description ), 'law_office_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
				<?php
				$law_office_woocommerce_sc = law_office_get_theme_option( 'front_page_woocommerce_products' );
				if ( 'products' == $law_office_woocommerce_sc ) {
					$law_office_woocommerce_sc_ids      = law_office_get_theme_option( 'front_page_woocommerce_products_per_page' );
					$law_office_woocommerce_sc_per_page = count( explode( ',', $law_office_woocommerce_sc_ids ) );
				} else {
					$law_office_woocommerce_sc_per_page = max( 1, (int) law_office_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
				}
				$law_office_woocommerce_sc_columns = max( 1, min( $law_office_woocommerce_sc_per_page, (int) law_office_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
				echo do_shortcode(
					"[{$law_office_woocommerce_sc}"
									. ( 'products' == $law_office_woocommerce_sc
											? ' ids="' . esc_attr( $law_office_woocommerce_sc_ids ) . '"'
											: '' )
									. ( 'product_category' == $law_office_woocommerce_sc
											? ' category="' . esc_attr( law_office_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
											: '' )
									. ( 'best_selling_products' != $law_office_woocommerce_sc
											? ' orderby="' . esc_attr( law_office_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
												. ' order="' . esc_attr( law_office_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
											: '' )
									. ' per_page="' . esc_attr( $law_office_woocommerce_sc_per_page ) . '"'
									. ' columns="' . esc_attr( $law_office_woocommerce_sc_columns ) . '"'
					. ']'
				);
				?>
			</div>
		</div>
	</div>
</div>
