<?php
/**
 * The Header: Logo and main menu
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( law_office_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'law_office_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'law_office_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('law_office_action_body_wrap_attributes'); ?>>

		<?php do_action( 'law_office_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'law_office_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('law_office_action_page_wrap_attributes'); ?>>

			<?php do_action( 'law_office_action_page_wrap_start' ); ?>

			<?php
			$law_office_full_post_loading = ( law_office_is_singular( 'post' ) || law_office_is_singular( 'attachment' ) ) && law_office_get_value_gp( 'action' ) == 'full_post_loading';
			$law_office_prev_post_loading = ( law_office_is_singular( 'post' ) || law_office_is_singular( 'attachment' ) ) && law_office_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $law_office_full_post_loading && ! $law_office_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="law_office_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to content", 'law-office' ); ?></a>
				<?php if ( law_office_sidebar_present() ) { ?>
				<a class="law_office_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to sidebar", 'law-office' ); ?></a>
				<?php } ?>
				<a class="law_office_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to footer", 'law-office' ); ?></a>

				<?php
				do_action( 'law_office_action_before_header' );

				// Header
				$law_office_header_type = law_office_get_theme_option( 'header_type' );
				if ( 'custom' == $law_office_header_type && ! law_office_is_layouts_available() ) {
					$law_office_header_type = 'default';
				}
				get_template_part( apply_filters( 'law_office_filter_get_template_part', "templates/header-" . sanitize_file_name( $law_office_header_type ) ) );

				// Side menu
				if ( in_array( law_office_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'law_office_action_after_header' );

			}
			?>

			<?php do_action( 'law_office_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( law_office_is_off( law_office_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $law_office_header_type ) ) {
						$law_office_header_type = law_office_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $law_office_header_type && law_office_is_layouts_available() ) {
						$law_office_header_id = law_office_get_custom_header_id();
						if ( $law_office_header_id > 0 ) {
							$law_office_header_meta = law_office_get_custom_layout_meta( $law_office_header_id );
							if ( ! empty( $law_office_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$law_office_footer_type = law_office_get_theme_option( 'footer_type' );
					if ( 'custom' == $law_office_footer_type && law_office_is_layouts_available() ) {
						$law_office_footer_id = law_office_get_custom_footer_id();
						if ( $law_office_footer_id ) {
							$law_office_footer_meta = law_office_get_custom_layout_meta( $law_office_footer_id );
							if ( ! empty( $law_office_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'law_office_action_page_content_wrap_class', $law_office_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'law_office_filter_is_prev_post_loading', $law_office_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( law_office_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'law_office_action_page_content_wrap_data', $law_office_prev_post_loading );
			?>>
				<?php
				do_action( 'law_office_action_page_content_wrap', $law_office_full_post_loading || $law_office_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'law_office_filter_single_post_header', law_office_is_singular( 'post' ) || law_office_is_singular( 'attachment' ) ) ) {
					if ( $law_office_prev_post_loading ) {
						if ( law_office_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'law_office_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$law_office_path = apply_filters( 'law_office_filter_get_template_part', 'templates/single-styles/' . law_office_get_theme_option( 'single_style' ) );
					if ( law_office_get_file_dir( $law_office_path . '.php' ) != '' ) {
						get_template_part( $law_office_path );
					}
				}

				// Widgets area above page
				$law_office_body_style   = law_office_get_theme_option( 'body_style' );
				$law_office_widgets_name = law_office_get_theme_option( 'widgets_above_page' );
				$law_office_show_widgets = ! law_office_is_off( $law_office_widgets_name ) && is_active_sidebar( $law_office_widgets_name );
				if ( $law_office_show_widgets ) {
					if ( 'fullscreen' != $law_office_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					law_office_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $law_office_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'law_office_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $law_office_body_style ? '_fullscreen' : ''; ?>">

					<div class="content">
						<?php
						do_action( 'law_office_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="law_office_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( law_office_is_singular( 'post' ) || law_office_is_singular( 'attachment' ) )
							&& $law_office_prev_post_loading 
							&& law_office_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'law_office_action_between_posts' );
						}

						// Widgets area above content
						law_office_create_widgets_area( 'widgets_above_content' );

						do_action( 'law_office_action_page_content_start_text' );
