<?php
/**
 * Theme storage manipulations
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) {
	exit; }

// Get theme variable
if ( ! function_exists( 'law_office_storage_get' ) ) {
	function law_office_storage_get( $var_name, $default = '' ) {
		global $LAW_OFFICE_STORAGE;
		return isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ? $LAW_OFFICE_STORAGE[ $var_name ] : $default;
	}
}

// Set theme variable
if ( ! function_exists( 'law_office_storage_set' ) ) {
	function law_office_storage_set( $var_name, $value ) {
		global $LAW_OFFICE_STORAGE;
		$LAW_OFFICE_STORAGE[ $var_name ] = $value;
	}
}

// Check if theme variable is empty
if ( ! function_exists( 'law_office_storage_empty' ) ) {
	function law_office_storage_empty( $var_name, $key = '', $key2 = '' ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return empty( $LAW_OFFICE_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return empty( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] );
		} else {
			return empty( $LAW_OFFICE_STORAGE[ $var_name ] );
		}
	}
}

// Check if theme variable is set
if ( ! function_exists( 'law_office_storage_isset' ) ) {
	function law_office_storage_isset( $var_name, $key = '', $key2 = '' ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return isset( $LAW_OFFICE_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return isset( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] );
		} else {
			return isset( $LAW_OFFICE_STORAGE[ $var_name ] );
		}
	}
}

// Delete theme variable
if ( ! function_exists( 'law_office_storage_unset' ) ) {
	function law_office_storage_unset( $var_name, $key = '', $key2 = '' ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			unset( $LAW_OFFICE_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			unset( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] );
		} else {
			unset( $LAW_OFFICE_STORAGE[ $var_name ] );
		}
	}
}

// Inc/Dec theme variable with specified value
if ( ! function_exists( 'law_office_storage_inc' ) ) {
	function law_office_storage_inc( $var_name, $value = 1 ) {
		global $LAW_OFFICE_STORAGE;
		if ( empty( $LAW_OFFICE_STORAGE[ $var_name ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = 0;
		}
		$LAW_OFFICE_STORAGE[ $var_name ] += $value;
	}
}

// Concatenate theme variable with specified value
if ( ! function_exists( 'law_office_storage_concat' ) ) {
	function law_office_storage_concat( $var_name, $value ) {
		global $LAW_OFFICE_STORAGE;
		if ( empty( $LAW_OFFICE_STORAGE[ $var_name ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = '';
		}
		$LAW_OFFICE_STORAGE[ $var_name ] .= $value;
	}
}

// Get array (one or two dim) element
if ( ! function_exists( 'law_office_storage_get_array' ) ) {
	function law_office_storage_get_array( $var_name, $key, $key2 = '', $default = '' ) {
		global $LAW_OFFICE_STORAGE;
		if ( empty( $key2 ) ) {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] ) ? $LAW_OFFICE_STORAGE[ $var_name ][ $key ] : $default;
		} else {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $LAW_OFFICE_STORAGE[ $var_name ][ $key ][ $key2 ] ) ? $LAW_OFFICE_STORAGE[ $var_name ][ $key ][ $key2 ] : $default;
		}
	}
}

// Set array element
if ( ! function_exists( 'law_office_storage_set_array' ) ) {
	function law_office_storage_set_array( $var_name, $key, $value ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$LAW_OFFICE_STORAGE[ $var_name ][] = $value;
		} else {
			$LAW_OFFICE_STORAGE[ $var_name ][ $key ] = $value;
		}
	}
}

// Set two-dim array element
if ( ! function_exists( 'law_office_storage_set_array2' ) ) {
	function law_office_storage_set_array2( $var_name, $key, $key2, $value ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = array();
		}
		if ( ! isset( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ][ $key ] = array();
		}
		if ( '' === $key2 ) {
			$LAW_OFFICE_STORAGE[ $var_name ][ $key ][] = $value;
		} else {
			$LAW_OFFICE_STORAGE[ $var_name ][ $key ][ $key2 ] = $value;
		}
	}
}

// Merge array elements
if ( ! function_exists( 'law_office_storage_merge_array' ) ) {
	function law_office_storage_merge_array( $var_name, $key, $value ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = array_merge( $LAW_OFFICE_STORAGE[ $var_name ], $value );
		} else {
			$LAW_OFFICE_STORAGE[ $var_name ][ $key ] = array_merge( $LAW_OFFICE_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Add array element after the key
if ( ! function_exists( 'law_office_storage_set_array_after' ) ) {
	function law_office_storage_set_array_after( $var_name, $after, $key, $value = '' ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			law_office_array_insert_after( $LAW_OFFICE_STORAGE[ $var_name ], $after, $key );
		} else {
			law_office_array_insert_after( $LAW_OFFICE_STORAGE[ $var_name ], $after, array( $key => $value ) );
		}
	}
}

// Add array element before the key
if ( ! function_exists( 'law_office_storage_set_array_before' ) ) {
	function law_office_storage_set_array_before( $var_name, $before, $key, $value = '' ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			law_office_array_insert_before( $LAW_OFFICE_STORAGE[ $var_name ], $before, $key );
		} else {
			law_office_array_insert_before( $LAW_OFFICE_STORAGE[ $var_name ], $before, array( $key => $value ) );
		}
	}
}

// Push element into array
if ( ! function_exists( 'law_office_storage_push_array' ) ) {
	function law_office_storage_push_array( $var_name, $key, $value ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			array_push( $LAW_OFFICE_STORAGE[ $var_name ], $value );
		} else {
			if ( ! isset( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] ) ) {
				$LAW_OFFICE_STORAGE[ $var_name ][ $key ] = array();
			}
			array_push( $LAW_OFFICE_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Pop element from array
if ( ! function_exists( 'law_office_storage_pop_array' ) ) {
	function law_office_storage_pop_array( $var_name, $key = '', $defa = '' ) {
		global $LAW_OFFICE_STORAGE;
		$rez = $defa;
		if ( '' === $key ) {
			if ( isset( $LAW_OFFICE_STORAGE[ $var_name ] ) && is_array( $LAW_OFFICE_STORAGE[ $var_name ] ) && count( $LAW_OFFICE_STORAGE[ $var_name ] ) > 0 ) {
				$rez = array_pop( $LAW_OFFICE_STORAGE[ $var_name ] );
			}
		} else {
			if ( isset( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] ) && is_array( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] ) && count( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] ) > 0 ) {
				$rez = array_pop( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] );
			}
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if ( ! function_exists( 'law_office_storage_inc_array' ) ) {
	function law_office_storage_inc_array( $var_name, $key, $value = 1 ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = array();
		}
		if ( empty( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ][ $key ] = 0;
		}
		$LAW_OFFICE_STORAGE[ $var_name ][ $key ] += $value;
	}
}

// Concatenate array element with specified value
if ( ! function_exists( 'law_office_storage_concat_array' ) ) {
	function law_office_storage_concat_array( $var_name, $key, $value ) {
		global $LAW_OFFICE_STORAGE;
		if ( ! isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ] = array();
		}
		if ( empty( $LAW_OFFICE_STORAGE[ $var_name ][ $key ] ) ) {
			$LAW_OFFICE_STORAGE[ $var_name ][ $key ] = '';
		}
		$LAW_OFFICE_STORAGE[ $var_name ][ $key ] .= $value;
	}
}

// Call object's method
if ( ! function_exists( 'law_office_storage_call_obj_method' ) ) {
	function law_office_storage_call_obj_method( $var_name, $method, $param = null ) {
		global $LAW_OFFICE_STORAGE;
		if ( null === $param ) {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ? $LAW_OFFICE_STORAGE[ $var_name ]->$method() : '';
		} else {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $LAW_OFFICE_STORAGE[ $var_name ] ) ? $LAW_OFFICE_STORAGE[ $var_name ]->$method( $param ) : '';
		}
	}
}

// Get object's property
if ( ! function_exists( 'law_office_storage_get_obj_property' ) ) {
	function law_office_storage_get_obj_property( $var_name, $prop, $default = '' ) {
		global $LAW_OFFICE_STORAGE;
		return ! empty( $var_name ) && ! empty( $prop ) && isset( $LAW_OFFICE_STORAGE[ $var_name ]->$prop ) ? $LAW_OFFICE_STORAGE[ $var_name ]->$prop : $default;
	}
}
