<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

$law_office_template = apply_filters( 'law_office_filter_get_template_part', law_office_blog_archive_get_template() );

if ( ! empty( $law_office_template ) && 'index' != $law_office_template ) {

	get_template_part( $law_office_template );

} else {

	law_office_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$law_office_stickies   = is_home()
								|| ( in_array( law_office_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) law_office_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$law_office_post_type  = law_office_get_theme_option( 'post_type' );
		$law_office_args       = array(
								'blog_style'     => law_office_get_theme_option( 'blog_style' ),
								'post_type'      => $law_office_post_type,
								'taxonomy'       => law_office_get_post_type_taxonomy( $law_office_post_type ),
								'parent_cat'     => law_office_get_theme_option( 'parent_cat' ),
								'posts_per_page' => law_office_get_theme_option( 'posts_per_page' ),
								'sticky'         => law_office_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $law_office_stickies )
															&& count( $law_office_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		law_office_blog_archive_start();

		do_action( 'law_office_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'law_office_action_before_page_author' );
			get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'law_office_action_after_page_author' );
		}

		if ( law_office_get_theme_option( 'show_filters' ) ) {
			do_action( 'law_office_action_before_page_filters' );
			law_office_show_filters( $law_office_args );
			do_action( 'law_office_action_after_page_filters' );
		} else {
			do_action( 'law_office_action_before_page_posts' );
			law_office_show_posts( array_merge( $law_office_args, array( 'cat' => $law_office_args['parent_cat'] ) ) );
			do_action( 'law_office_action_after_page_posts' );
		}

		do_action( 'law_office_action_blog_archive_end' );

		law_office_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
