<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

if ( law_office_sidebar_present() ) {
	
	$law_office_sidebar_type = law_office_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $law_office_sidebar_type && ! law_office_is_layouts_available() ) {
		$law_office_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $law_office_sidebar_type ) {
		// Default sidebar with widgets
		$law_office_sidebar_name = law_office_get_theme_option( 'sidebar_widgets' );
		law_office_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $law_office_sidebar_name ) ) {
			dynamic_sidebar( $law_office_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$law_office_sidebar_id = law_office_get_custom_sidebar_id();
		do_action( 'law_office_action_show_layout', $law_office_sidebar_id );
	}
	$law_office_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $law_office_out ) ) {
		$law_office_sidebar_position    = law_office_get_theme_option( 'sidebar_position' );
		$law_office_sidebar_position_ss = law_office_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $law_office_sidebar_position );
			echo ' sidebar_' . esc_attr( $law_office_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $law_office_sidebar_type );

			if ( 'float' == $law_office_sidebar_position_ss ) {
				echo ' sidebar_float';
			}
			$law_office_sidebar_scheme = law_office_get_theme_option( 'sidebar_scheme' );
			if ( ! empty( $law_office_sidebar_scheme ) && ! law_office_is_inherit( $law_office_sidebar_scheme ) ) {
				echo ' scheme_' . esc_attr( $law_office_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="law_office_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'law_office_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $law_office_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$law_office_title = apply_filters( 'law_office_filter_sidebar_control_title', 'float' == $law_office_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'law-office' ) : '' );
				$law_office_text  = apply_filters( 'law_office_filter_sidebar_control_text', 'above' == $law_office_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'law-office' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $law_office_title ); ?>"><?php echo esc_html( $law_office_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'law_office_action_before_sidebar', 'sidebar' );
				law_office_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $law_office_out ) );
				do_action( 'law_office_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'law_office_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
