<?php
/**
 * The template to display single post
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

// Full post loading
$full_post_loading          = law_office_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = law_office_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = law_office_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$law_office_related_position   = law_office_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$law_office_posts_navigation   = law_office_get_theme_option( 'posts_navigation' );
$law_office_prev_post          = false;
$law_office_prev_post_same_cat = law_office_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( law_office_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	law_office_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'law_office_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $law_office_posts_navigation ) {
		$law_office_prev_post = get_previous_post( $law_office_prev_post_same_cat );  // Get post from same category
		if ( ! $law_office_prev_post && $law_office_prev_post_same_cat ) {
			$law_office_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $law_office_prev_post ) {
			$law_office_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $law_office_prev_post ) ) {
		law_office_sc_layouts_showed( 'featured', false );
		law_office_sc_layouts_showed( 'title', false );
		law_office_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $law_office_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/content', 'single-' . law_office_get_theme_option( 'single_style' ) ), 'single-' . law_office_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $law_office_related_position, 'inside' ) === 0 ) {
		$law_office_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'law_office_action_related_posts' );
		$law_office_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $law_office_related_content ) ) {
			$law_office_related_position_inside = max( 0, min( 9, law_office_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $law_office_related_position_inside ) {
				$law_office_related_position_inside = mt_rand( 1, 9 );
			}

			$law_office_p_number         = 0;
			$law_office_related_inserted = false;
			$law_office_in_block         = false;
			$law_office_content_start    = strpos( $law_office_content, '<div class="post_content' );
			$law_office_content_end      = strrpos( $law_office_content, '</div>' );

			for ( $i = max( 0, $law_office_content_start ); $i < min( strlen( $law_office_content ) - 3, $law_office_content_end ); $i++ ) {
				if ( $law_office_content[ $i ] != '<' ) {
					continue;
				}
				if ( $law_office_in_block ) {
					if ( strtolower( substr( $law_office_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$law_office_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $law_office_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $law_office_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$law_office_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $law_office_content[ $i + 1 ] && in_array( $law_office_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$law_office_p_number++;
					if ( $law_office_related_position_inside == $law_office_p_number ) {
						$law_office_related_inserted = true;
						$law_office_content = ( $i > 0 ? substr( $law_office_content, 0, $i ) : '' )
											. $law_office_related_content
											. substr( $law_office_content, $i );
					}
				}
			}
			if ( ! $law_office_related_inserted ) {
				if ( $law_office_content_end > 0 ) {
					$law_office_content = substr( $law_office_content, 0, $law_office_content_end ) . $law_office_related_content . substr( $law_office_content, $law_office_content_end );
				} else {
					$law_office_content .= $law_office_related_content;
				}
			}
		}

		law_office_show_layout( $law_office_content );
	}

	// Comments
	do_action( 'law_office_action_before_comments' );
	comments_template();
	do_action( 'law_office_action_after_comments' );

	// Related posts
	if ( 'below_content' == $law_office_related_position
		&& ( 'scroll' != $law_office_posts_navigation || law_office_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || law_office_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'law_office_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $law_office_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $law_office_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $law_office_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $law_office_prev_post ) ); ?>"
			<?php do_action( 'law_office_action_nav_links_single_scroll_data', $law_office_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
