<?php

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'law_office_advanced_popups_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'law_office_advanced_popups_theme_setup9', 9 );
    function law_office_advanced_popups_theme_setup9() {
        if ( is_admin() ) {
            add_filter( 'law_office_filter_tgmpa_required_plugins', 'law_office_advanced_popups_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'law_office_advanced_popups_tgmpa_required_plugins' ) ) {    
    function law_office_advanced_popups_tgmpa_required_plugins( $list = array() ) {
        if ( law_office_storage_isset( 'required_plugins', 'advanced-popups' ) && law_office_storage_get_array( 'required_plugins', 'advanced-popups', 'install' ) !== false ) {
            $list[] = array(
                'name'     => law_office_storage_get_array( 'required_plugins', 'advanced-popups', 'title' ),
                'slug'     => 'advanced-popups',
                'required' => false,
            );
        }
        return $list;
    }
}

// Check if plugin installed and activated
if ( ! function_exists( 'law_office_exists_advanced_popups' ) ) {
    function law_office_exists_advanced_popups() {
        return function_exists('adp_init');
    }
}
