<?php
/**
 * Required plugins
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$law_office_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'law-office' ),
	'page_builders' => esc_html__( 'Page Builders', 'law-office' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'law-office' ),
	'socials'       => esc_html__( 'Socials and Communities', 'law-office' ),
	'events'        => esc_html__( 'Events and Appointments', 'law-office' ),
	'content'       => esc_html__( 'Content', 'law-office' ),
	'other'         => esc_html__( 'Other', 'law-office' ),
);
$law_office_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'law-office' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'law-office' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $law_office_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'law-office' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'law-office' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $law_office_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'law-office' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'law-office' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $law_office_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'law-office' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'law-office' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $law_office_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'law-office' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'law-office' ),
		'required'    => false,
		'logo'        => 'woocommerce.png',
		'group'       => $law_office_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'law-office' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'law-office' ),
		'required'    => false,
		'logo'        => 'elegro-payment.png',
		'group'       => $law_office_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'law-office' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'law-office' ),
		'required'    => false,
        'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
        'logo'        => 'instagram-feed.png',
		'group'       => $law_office_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'law-office' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'law-office' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $law_office_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'law-office' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'booked.png',
		'group'       => $law_office_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'law-office' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $law_office_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'law-office' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'law-office' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $law_office_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'law-office' ),
		'description' => '',
		'required'    => false,
        'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
        'logo'        => law_office_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $law_office_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'law-office' ),
		'description' => '',
		'required'    => false,
		'logo'        => law_office_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $law_office_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'law-office' ),
		'description' => '',
		'required'    => false,
        'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
        'logo'        => law_office_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $law_office_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'law-office' ),
		'description' => '',
		'required'    => false,
		'logo'        => law_office_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $law_office_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'law-office' ),
		'description' => '',
		'required'    => false,
        'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
        'logo'        => law_office_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $law_office_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'law-office' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $law_office_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'law-office' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'revslider.png',
		'group'       => $law_office_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'law-office' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'law-office' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $law_office_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'law-office' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'law-office' ),
		'required'    => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $law_office_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'law-office' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'law-office' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $law_office_theme_required_plugins_groups['other'],
	),
);

if ( LAW_OFFICE_THEME_FREE ) {
	unset( $law_office_theme_required_plugins['js_composer'] );
	unset( $law_office_theme_required_plugins['booked'] );
	unset( $law_office_theme_required_plugins['the-events-calendar'] );
	unset( $law_office_theme_required_plugins['calculated-fields-form'] );
	unset( $law_office_theme_required_plugins['essential-grid'] );
	unset( $law_office_theme_required_plugins['revslider'] );
	unset( $law_office_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $law_office_theme_required_plugins['trx_updater'] );
	unset( $law_office_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
law_office_storage_set( 'required_plugins', $law_office_theme_required_plugins );
