<?php
/**
 * Skins support: Main skin file for the skin 'Default'
 *
 * Load scripts and styles,
 * and other operations that affect the appearance and behavior of the theme
 * when the skin is activated
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0.46
 */



// SKIN SETUP
//--------------------------------------------------------------------

// Setup fonts, colors, blog and single styles, etc.
$law_office_skin_path = law_office_get_file_dir( law_office_skins_get_current_skin_dir() . 'skin-setup.php' );
if ( ! empty( $law_office_skin_path ) ) {
	require_once $law_office_skin_path;
}

// Skin options
$law_office_skin_path = law_office_get_file_dir( law_office_skins_get_current_skin_dir() . 'skin-options.php' );
if ( ! empty( $law_office_skin_path ) ) {
	require_once $law_office_skin_path;
}

// Required plugins
$law_office_skin_path = law_office_get_file_dir( law_office_skins_get_current_skin_dir() . 'skin-plugins.php' );
if ( ! empty( $law_office_skin_path ) ) {
	require_once $law_office_skin_path;
}

// Demo import
$law_office_skin_path = law_office_get_file_dir( law_office_skins_get_current_skin_dir() . 'skin-demo-importer.php' );
if ( ! empty( $law_office_skin_path ) ) {
	require_once $law_office_skin_path;
}


// TRX_ADDONS SETUP
//--------------------------------------------------------------------

// Filter to add in the required plugins list
// Priority 11 to add new plugins to the end of the list
if ( ! function_exists( 'law_office_skin_tgmpa_required_plugins' ) ) {
	add_filter( 'law_office_filter_tgmpa_required_plugins', 'law_office_skin_tgmpa_required_plugins', 11 );
	function law_office_skin_tgmpa_required_plugins( $list = array() ) {
		// ToDo: Check if plugin is in the 'required_plugins' and add his parameters to the TGMPA-list
		//       Replace 'skin-specific-plugin-slug' to the real slug of the plugin
		if ( law_office_storage_isset( 'required_plugins', 'skin-specific-plugin-slug' ) ) {
			$list[] = array(
				'name'     => law_office_storage_get_array( 'required_plugins', 'skin-specific-plugin-slug', 'title' ),
				'slug'     => 'skin-specific-plugin-slug',
				'required' => false,
			);
		}
		return $list;
	}
}

// Filter to add/remove components of ThemeREX Addons when current skin is active
if ( ! function_exists( 'law_office_skin_trx_addons_default_components' ) ) {
    add_filter('trx_addons_filter_load_options', 'law_office_skin_trx_addons_default_components', 20);
	function law_office_skin_trx_addons_default_components($components) {
        // ToDo: Set key value in the array $components to 0 (disable component) or 1 (enable component)
		//---> For example (enable reviews for posts):
		//---> $components['components_components_reviews'] = 1;
		return $components;
	}
}

// Filter to add/remove CPT
if ( ! function_exists( 'law_office_skin_trx_addons_cpt_list' ) ) {
	add_filter('trx_addons_cpt_list', 'law_office_skin_trx_addons_cpt_list');
	function law_office_skin_trx_addons_cpt_list( $list = array() ) {
		// ToDo: Unset CPT slug from list to disable CPT when current skin is active
		//---> For example to disable CPT 'Portfolio':
		//---> unset( $list['portfolio'] );
		return $list;
	}
}

// Filter to add/remove shortcodes
if ( ! function_exists( 'law_office_skin_trx_addons_sc_list' ) ) {
	add_filter('trx_addons_sc_list', 'law_office_skin_trx_addons_sc_list');
	function law_office_skin_trx_addons_sc_list( $list = array() ) {

		unset( $list['blogger']['templates']['default']['classic_2'] );
		unset( $list['blogger']['templates']['default']['over_centered'] );

        $list['blogger']['templates']['lay_portfolio']['style-1'] = array(
            'title'  => esc_html__('Style 1', 'law-office'),
            'layout' => array(
                'featured' => array(
                ),
                'content' => array(
                    'title', 'meta_categories', 'meta', 'excerpt', 'readmore'
                )
            )
        );
        $list['blogger']['templates']['lay_portfolio']['style-2'] = array(
            'title'  => esc_html__('Style 2', 'law-office'),
            'layout' => array(
                'featured' => array(
                ),
                'content' => array(
                    'title', 'meta_categories', 'meta', 'excerpt', 'readmore'
                )
            )
        );

		$list['blogger']['templates']['default']['classic_3'] = array(
			'title'  => esc_html__('Classic with header above', 'law-office'),
			'layout' => array(
				'header' => array(
					'meta', 'title'
				),
				'featured' => array(
				),
				'content' => array(
					'excerpt', 'readmore'
				)
			)
		);
		$list['blogger']['templates']['default']['over_bottom'] = array(
			'title'  => esc_html__('Info over image (bottom)', 'law-office'),
			'layout' => array(
				'featured' => array(
					'bc' => array(
						'meta', 'title', 'readmore'
					)
				),
			)
		);

		return $list;
	}
}

// SCRIPTS AND STYLES
//--------------------------------------------------

// Enqueue skin-specific scripts
// Priority 1050 -  before main theme plugins-specific (1100)
if ( ! function_exists( 'law_office_skin_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'law_office_skin_frontend_scripts', 1050 );
	function law_office_skin_frontend_scripts() {
		$law_office_url = law_office_get_file_url( law_office_skins_get_current_skin_dir() . 'css/style.css' );
		if ( '' != $law_office_url ) {
			wp_enqueue_style( 'law-office-skin-' . esc_attr( law_office_skins_get_current_skin_name() ), $law_office_url, array(), null );
		}
		$law_office_url = law_office_get_file_url( law_office_skins_get_current_skin_dir() . 'skin.js' );
		if ( '' != $law_office_url ) {
			wp_enqueue_script( 'law-office-skin-' . esc_attr( law_office_skins_get_current_skin_name() ), $law_office_url, array( 'jquery' ), null, true );
		}
	}
}


// Enqueue additional responsive styles for frontend
// Priority 2050 -  after main theme plugins-specific responsive (2000)
if ( ! function_exists( 'law_office_skin_trx_addons_responsive_styles' ) ) {
	add_action( 'wp_enqueue_scripts', 'law_office_skin_trx_addons_responsive_styles', 2050 );
	function law_office_skin_trx_addons_responsive_styles() {
		if ( law_office_is_on( law_office_get_theme_option( 'debug_mode' ) ) ) {
			$law_office_url_additional_1 = law_office_get_file_url( 'plugins/trx_addons/trx_addons-additional-responsive-1.css' );
			$law_office_url_additional_2 = law_office_get_file_url( 'plugins/trx_addons/trx_addons-additional-responsive-2.css' );
			$law_office_url_additional_3 = law_office_get_file_url( 'plugins/trx_addons/trx_addons-additional-responsive-3.css' );
            if ( '' != $law_office_url_additional_1 ) {
                wp_enqueue_style( 'law-office-trx-addons-additional-responsive-1', $law_office_url_additional_1, array(), null, law_office_media_for_load_css_responsive( 'trx-addons-1' ) );
			}
            if ( '' != $law_office_url_additional_2 ) {
                wp_enqueue_style( 'law-office-trx-addons-additional-responsive-2', $law_office_url_additional_2, array(), null, law_office_media_for_load_css_responsive( 'trx-addons-2' ) );
            }
            if ( '' != $law_office_url_additional_3 ) {
                wp_enqueue_style( 'law-office-trx-addons-additional-responsive-3', $law_office_url_additional_3, array(), null, law_office_media_for_load_css_responsive( 'trx-addons-3' ) );
            }
		}
	}
}

// Merge responsive styles
if ( ! function_exists( 'law_office_skin_trx_addons_merge_styles_responsive' ) ) {
	add_filter('law_office_filter_merge_styles_responsive', 'law_office_skin_trx_addons_merge_styles_responsive', 20);
	function law_office_skin_trx_addons_merge_styles_responsive( $list ) {
		$list[] = 'plugins/trx_addons/trx_addons-additional-responsive-1.css';
		$list[] = 'plugins/trx_addons/trx_addons-additional-responsive-2.css';
		$list[] = 'plugins/trx_addons/trx_addons-additional-responsive-3.css';
		return $list;
	}
}


// Custom styles
$law_office_style_path = law_office_get_file_dir( law_office_skins_get_current_skin_dir() . 'css/style.php' );
if ( ! empty( $law_office_style_path ) ) {
	require_once $law_office_style_path;
}



// ADD NEW PARAMS
//--------------------------------------------------


// Add new output types (layouts) in the shortcodes
if ( ! function_exists( 'law_office_skin_trx_addons_sc_type' ) ) {
	add_filter( 'trx_addons_sc_type', 'law_office_skin_trx_addons_sc_type', 10, 2 );
	function law_office_skin_trx_addons_sc_type( $list, $sc ) {

        if ( 'trx_sc_price' == $sc ) {
            $list['plain'] = esc_html__( 'Plain', 'law-office' );
            $list['metro'] = esc_html__( 'Metro', 'law-office' );
        }
        if ( 'trx_sc_icons' == $sc ) {
            $list['motley'] = esc_html__( 'Motley', 'law-office' );
            $list['simple'] = esc_html__( 'Simple', 'law-office' );
        }
        if ( 'trx_sc_services' == $sc ) {
            $list['modern'] = esc_html__( 'Modern', 'law-office' );
        }
		if ( 'trx_sc_team' == $sc ) {
			$list['metro'] = esc_html__( 'Metro', 'law-office' );
            $list['3d-simple'] = esc_html__( '3D (simple)', 'law-office' );
        }
		if ( 'trx_sc_testimonials' == $sc ) {
            $list['classic'] = esc_html__( 'Classic', 'law-office' );
            $list['list'] = esc_html__( 'List', 'law-office' );
			$list['decoration'] = esc_html__( 'Decoration', 'law-office' );
			$list['chit'] = esc_html__( 'Chit', 'law-office' );
		}
        if ( 'trx_sc_blogger' == $sc ) {
            $list['lay_portfolio'] = esc_html__('Layout Portfolio', 'law-office' );
        }
        if ( 'trx_sc_portfolio' == $sc ) {
            $list['simple'] = esc_html__('Simple', 'law-office' );
            $list['band'] = esc_html__('Band', 'law-office' );
        }
        if ( 'trx_sc_layouts_search' == $sc ) {
            $list['modern'] = esc_html__('Modern', 'law-office' );
        }
		if ( 'trx_sc_socials' == $sc ) {
			$list['modern'] = esc_html__('Modern', 'law-office' );
		}
        return $list;
	}
}

// Add new params to the default shortcode's atts
if ( ! function_exists( 'law_office_skin_trx_addons_sc_atts' ) ) {
    add_filter('trx_addons_sc_atts', 'law_office_skin_trx_addons_sc_atts', 10, 2);
    function law_office_skin_trx_addons_sc_atts($atts, $sc)  {
        if ( 'trx_sc_skills' == $sc ) {
            $atts['align'] = 'none';
            $atts['show_divider'] = '';
        }
        if ('trx_sc_icons' == $sc ) {
            $atts['link_text'] = '';
        }
        if ( 'trx_sc_services' == $sc ) {
            $atts['show_subtitle'] = '';
        }
        if ( 'trx_sc_layouts' == $sc ) {
            $atts['panel_menu_style'] = '';
            $atts['vertical_menu_style'] = '';
        }
        if ( 'trx_sc_layouts_search' == $sc ) {
            $atts['logo_search'] = 'url';
            $atts['logo_search_retina'] = 'url';
            $atts['scheme_search'] = '';
        }
        if ( 'trx_sc_events' == $sc ) {
            $atts['hide_excerpt'] = '';
            $atts['more_text'] = '';
        }
        return $atts;
    }
}

// Add item params to icons
if ( ! function_exists( 'law_office_skin_filter_icons_add_param' ) ) {
    add_filter( 'trx_addons_sc_param_group_params', 'law_office_skin_filter_icons_add_param', 10, 2 );
    function law_office_skin_filter_icons_add_param( $params, $sc ) {

        if ( in_array( $sc, array( 'trx_sc_icons' ) ) ) {
            if ( isset( $params[0]['name'] ) && isset( $params[0]['label'] ) ) {
                array_splice($params, 6, 0, array( array(
                    'name'        => 'link_text',
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'label'       => esc_html__( 'Link text', 'law-office' ),
                    'label_block' => false,
                    'default' => esc_html__('Read more', 'law-office'),
                ) ) );
            }
        }
        return $params;
    }
}



// Add/Remove params to the mouse helper
if (!function_exists('law_office_skin_mouse_helper_add_params_to_elements')) {
	add_action( 'elementor/element/before_section_start', 'law_office_skin_mouse_helper_add_params_to_elements', 11, 3 );
	add_action( 'elementor/widget/before_section_start', 'law_office_skin_mouse_helper_add_params_to_elements', 11, 3 );
	function law_office_skin_mouse_helper_add_params_to_elements($element, $section_id, $args)  {
		if (is_object($element)) {
			if ( in_array( $element->get_name(), array( 'section', 'column', 'common' ) ) && $section_id == '_section_responsive' ) {
				$element->remove_control( 'mouse_helper_bd_color' );
			}
		}
	}
}
if (!function_exists('law_office_add_portfolio_params_to_elements')) {
    add_action( 'elementor/element/before_section_end', 'law_office_add_portfolio_params_to_elements', 11, 3 );
    function law_office_add_portfolio_params_to_elements($element, $section_id, $args)  {
        if ( is_object( $element ) ) {
            $el_name = $element->get_name();
            if ( 'trx_sc_portfolio' == $el_name  && 'section_sc_portfolio' === $section_id ) {
                $element->remove_control( 'use_masonry' );
                $element->remove_control( 'use_gallery' );

                if ( 'trx_sc_portfolio' == $el_name  && 'section_sc_portfolio' === $section_id ) {
                    $element->add_control(
                        'use_masonry', array(
                            'label' => esc_html__('Use masonry', 'law-office'),
                            'label_block' => false,
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_off' => esc_html__('Off', 'law-office'),
                            'label_on' => esc_html__('On', 'law-office'),
                            'return_value' => '1',
                            'condition' => [
                                'type' => ['eclipse']
                            ],
                        )
                    );
                    $element->add_control(
                        'use_gallery', array(
                            'label' => esc_html__('Use gallery', 'law-office'),
                            'label_block' => false,
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_off' => esc_html__('Off', 'law-office'),
                            'label_on' => esc_html__('On', 'law-office'),
                            'default' => trx_addons_is_on(trx_addons_get_option('portfolio_use_gallery')) ? '1' : '',
                            'return_value' => '1',
                            'condition' => [
                                'type' => ['eclipse']
                            ],
                        )
                    );
                }

            }
        }
    }
}


// Add/Remove params to the existings sections: use templates as Tab content
if (!function_exists('law_office_skin_elm_add_params_new_set_after')) {
    add_action('elementor/element/after_section_start', 'law_office_skin_elm_add_params_new_set_after', 10, 3);
    function law_office_skin_elm_add_params_new_set_after($element, $section_id, $args)  {
        if (is_object($element)) {
            $el_name = $element->get_name();
            if ('trx_sc_skills' == $el_name && $section_id == 'section_sc_skills') {
                $element->add_control(
                    'align', array(
                        'label_block' => false,
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'label' => __("Skills alignment", 'law-office'),
                        'options' => array(
                            'none' => esc_html__("Default", 'law-office'),
                            'left' => esc_html__('Left', 'law-office'),
                            'center' => esc_html__('Center', 'law-office'),
                            'right' => esc_html__('Right', 'law-office'),
                        ),
                        'default' => 'none',
                        'condition' => array(
                            'type' => array('counter')
                        )
                    )
                );
            }

            if ('trx_sc_services' == $el_name && $section_id == 'section_sc_services_details') {
                $element->add_control(
                    'show_subtitle', array(
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'label' => esc_html__('Subtitle', 'law-office'),
                        'label_off' => esc_html__('Show', 'law-office'),
                        'label_on' => esc_html__('Hide', 'law-office'),
                        'return_value' => '1',
                        'condition' => array(
                            'type' => array('default', 'modern')
                        )
                    )
                );
            }
        }
    }
}

// Add Tab section and params to shortcode events
if (!function_exists('law_office_skin_events_elm_add_params_new_set')) {
    add_action('elementor/element/before_section_start', 'law_office_skin_events_elm_add_params_new_set', 10, 3);
    function law_office_skin_events_elm_add_params_new_set($element, $section_id, $args) {

        if (!is_object($element)) return;
        $el_name = $element->get_name();

        // Add control 'More Text' Events
        if ('trx_sc_events' == $el_name && $section_id == 'section_slider_params') {

            $element->start_controls_section(
                'section_sc_events_details', array(
                    'label' => esc_html__('Details', 'law-office'),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT
                )
            );
            $element->add_control(
                'more_text', array(
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'label' => esc_html__('More text', 'law-office'),
                    'label_block' => false,
                    'default' => esc_html__('Read more', 'law-office'),
                    'condition' => array(
                        'type' => array('default', 'classic', 'modern', 'alter')
                    )
                )
            );
            $element->add_control(
                'hide_excerpt', array(
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label' => esc_html__('Hide excerpt', 'law-office'),
                    'label_off' => __( 'Off', 'law-office' ),
                    'label_on' => __( 'On', 'law-office' ),
                    'return_value' => '1',
                    'condition' => array(
                        'type' => array('default', 'classic', 'modern', 'alter')
                    )
                )
            );


            $element->end_controls_section();
        }
    }
}

// Add/Remove params to the existings sections: use templates as Tab content
if (!function_exists('law_office_elm_add_params_new_set')) {
	add_action( 'elementor/element/before_section_end', 'law_office_elm_add_params_new_set', 10, 3 );
	function law_office_elm_add_params_new_set($element, $section_id, $args) {

		if ( ! is_object($element) ) return;
		$el_name = $element->get_name();

		// Add template selector
		if ( $el_name == 'trx_sc_button' && $section_id == 'section_sc_button' ) {
			$control   = $element->get_controls( 'buttons' );
			$fields    = $control['fields'];
			$default   = $control['default'];
			if ( is_array( $default ) ) {
				for( $i=0; $i < count($default); $i++ ) {
					$default[$i]['shadow'] = 0;
				}
			}
			$fields['shadow'] = array(
				'name' => 'shadow',
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label'        => esc_html__( 'Shadow', 'law-office' ),
				'label_block'  => false,
				'label_off'    => esc_html__( 'Off', 'law-office' ),
				'label_on'     => esc_html__( 'On', 'law-office' ),
				'condition'    => array(
					'type' => array('default', 'decoration', 'hover')
				)
			);
			$element->update_control( 'buttons', array(
					'default' => $default,
					'fields' => $fields
				)
			);
		}

		if ( $el_name == 'trx_sc_price' && $section_id == 'section_sc_price' ) {
			$control   = $element->get_controls( 'prices' );
			$fields    = $control['fields'];
			$default   = $control['default'];
			if ( is_array( $default ) ) {
				for( $i=0; $i < count($default); $i++ ) {
					$default[$i]['price_active'] = 0;
				}
			}
			$fields['price_active'] = array(
				'name' => 'price_active',
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label'        => esc_html__( 'Price Active', 'law-office' ),
				'label_block'  => false,
				'label_off'    => esc_html__( 'Off', 'law-office' ),
				'label_on'     => esc_html__( 'On', 'law-office' ),
			);
			$element->update_control( 'prices', array(
					'default' => $default,
					'fields' => $fields
				)
			);
		}

		if ( $section_id == 'section_sc_title' ) {
			$element->add_control( 'sc_button_shadow', array(
				'label_block'  => false,
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label' => esc_html__("Shadow", 'law-office'),
				'label_on' => esc_html__( 'On', 'law-office' ),
				'label_off' => esc_html__( 'Off', 'law-office' ),
				'condition'    => array(
					'link_style' => array('default', 'decoration', 'hover')
				)
			) );
		}

        if ('trx_sc_services' == $el_name && $section_id == 'section_sc_services') {
            $element->update_control(
                'featured', array(
                    'description' => wp_kses_data( __('Please note: some options might be incompatible with certain layouts.', 'law-office') ),
                    'condition' => [
                        'type' => ['default', 'modern']
                    ],
                )
            );
            $element->update_control(
                'featured_position', array(
                    'description' => '',
                    'condition' => [
                        'type' => ['default', 'modern']
                    ],
                )
            );
            $element->update_responsive_control(
                'columns', array(
                    'condition' => [
                        'type' => ['default']
                    ],
                )
            );

        }

        if ('trx_sc_services' == $el_name && $section_id == 'section_slider_params') {
            $element->update_control(
                'slider', array(
                    'condition' => [
                        'type' => ['default', 'modern']
                    ],
                )
            );
        }
        if ('trx_sc_services' == $el_name && $section_id == 'section_sc_services_details') {
            $element->update_control(
                'more_text', array(
                    'condition' => [
                        'type' => ['default', 'modern']
                    ],
                )
            );
        }
        /* Add control for filter blogger */
        if ( 'trx_sc_blogger' == $el_name  && 'section_sc_blogger' === $section_id ) {
            $element->add_control(
                'filter_style', array(
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'label' => esc_html__( "Filter style", 'law-office' ),
                    'label_block' => false,
                    'options' => array(
                        'default' => esc_html__('Default', 'law-office'),
                        'toggle' => esc_html__('Toggle', 'law-office'),
                    ),
                    'default' => 'default',
                    'prefix_class' => 'sc_style_',
                    'condition' => ['filters_tabs_position' => 'top'],
                )
            );
        }

        if ('trx_sc_layouts' == $el_name && $section_id == 'section_sc_layouts') {
            $element->update_control(
                'popup_id', array(
                    'condition' => array(
                        'type' => array('popup', 'panel', 'panel-menu')
                    )
                )
            );

            $element->add_control(
                'panel_menu_style', array(
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'label' => esc_html__( 'Select panel menu style', 'law-office' ),
                    'label_block' => false,
                    'options' => array(
                        'fullscreen' => esc_html__('Fullscreen', 'law-office'),
                        'narrow' => esc_html__('Narrow', 'law-office'),
                    ),
                    'default' => 'fullscreen',
                    'condition' => array(
                         'type' => array('panel-menu')
                    )
                )
            );
            $element->add_control(
                'vertical_menu_style', array(
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'label' => esc_html__( 'Select vertical menu style', 'law-office' ),
                    'description' => esc_html__( 'If the vertical menu(dropdown) in the "Panel menu" is used, then some styles are applied to it', 'law-office' ),
                    'label_block' => false,
                    'options' => array(
                        'default' => esc_html__('Default', 'law-office'),
                        'extra' => esc_html__('Extra', 'law-office'),
                    ),
                    'default' => 'default',
                    'condition' => array(
                        'type' => array('panel-menu')
                    )
                )
            );
        }
        //Search controls & dependencies
        if ('trx_sc_layouts_search' == $element->get_name() && 'section_sc_layouts_search' == $section_id) {

            $element->update_control(
                'style',
                [
                    'condition' => [
                        'type' => ['default'],
                    ]
                ]
            );

            $element->add_control(
                'logo_search', array(
                    'label' => esc_html__( 'Logo', 'law-office' ),
                    'description' => esc_html__( "Select or upload image for site's logo. If empty - theme-specific logo is used", 'law-office'),
                    'type' => \Elementor\Controls_Manager::MEDIA,
                    'default' => array(
                        'url' => ''
                    ),
                    'condition' => array(
                        'type' => array('modern')
                    )
                )
            );

            $element->add_control(
                'logo_search_retina', array(
                    'label' => esc_html__( 'Logo Retina', 'law-office' ),
                    'description' => esc_html__( "Select or upload image for site's logo on the Retina displays", 'law-office'),
                    'type' => \Elementor\Controls_Manager::MEDIA,
                    'default' => array(
                        'url' => ''
                    ),
                    'condition' => array(
                        'type' => array('modern')
                    )
                )
            );

            $element->add_control(
                'scheme_search', array(
                    'type'         => \Elementor\Controls_Manager::SELECT,
                    'label'        => esc_html__( 'Search Color scheme', 'law-office' ),
                    'label_block'  => false,
                    'options'      => law_office_array_merge( array( '' => esc_html__( 'Inherit', 'law-office' ) ), law_office_get_list_schemes() ),
                    'render_type'  => 'template',	// ( none | ui | template ) - reload template after parameter is changed
                    'default'      => '',
                    'condition' => array(
                        'type' => array('modern')
                    )
                )
            );


        }

        /* Portfolio Fill Hide Columns */
        if ('trx_sc_portfolio' == $el_name && $section_id == 'section_sc_portfolio') {
            $element->update_control(
                'columns', array(
                    'condition' => [
                        'type' => [ 'band', 'default']
                    ],
                )
            );
        }
        /* Hide style 'List' in Trx Booked Calendar layout */
        if ('trx_sc_booked_calendar' == $el_name && $section_id == 'section_sc_booked') {
            $element->update_control(
                'style', array(
                    'options' => [
                        'calendar' => esc_html__('Calendar', 'law-office'),
                    ],
                )
            );
        }
  	}
}

// Substitute tab content with layout
if (!function_exists('law_office_elm_add_params_class_new_set')) {
	add_filter( 'elementor/widget/render_content', 'law_office_elm_add_params_class_new_set', 10, 2 );
	function law_office_elm_add_params_class_new_set($html, $element) {
		if ( is_object($element) ) {
			$el_name = $element->get_name();
			$settings = $element->get_settings();
			if ( $el_name == 'trx_sc_button' ) {
				if ( is_array( $settings['buttons'] ) ) {
					foreach( $settings['buttons'] as $k => $tab ) {
						if ( ! empty( $tab['shadow'] ) && ($tab['type'] == 'default') ) {
							$parts = explode( 'class="sc_button ', $html );
							$parts[ $k + 1 ] = 'sc_button_shadow ' . $parts[ $k + 1 ];
							$html = join( 'class="sc_button ', $parts );
						}
					}
				}
			}

			if ( $el_name == 'trx_sc_price' ) {
				if ( is_array( $settings['prices'] ) ) {
					foreach( $settings['prices'] as $k => $tab ) {
						if ( ! empty( $tab['price_active'] ) ) {
							$parts = explode( 'class="sc_price_item ', $html );
							$parts[ $k + 1 ] = 'sc_price_active ' . $parts[ $k + 1 ];
							$html = join( 'class="sc_price_item ', $parts );
						}
					}
				}
			}

			$settings = $element->get_settings();
			if ( ! empty( $settings['sc_button_shadow'] ) ) {
				$html = preg_replace('/(class="sc_button sc_button_)(default|hover|decoration) /', '$1$2 sc_button_shadow ', $html);
			}

		}
		return $html;
	}
}
// Enqueue script tilt for some Shortcodes
if ( ! function_exists( 'law_office_skin_filter_trx_addons_sc_output' ) ) {
    add_filter('trx_addons_sc_output', 'law_office_skin_filter_trx_addons_sc_output', 10, 4);
    function law_office_skin_filter_trx_addons_sc_output($output, $sc, $atts, $content)   {
		    if ( 'trx_sc_team' == $sc && ( '3d-simple' == $atts['type'] ) ) {
            wp_enqueue_script('tilt', law_office_get_file_url('js/tilt/vanilla-tilt.min.js'), array('jquery'), null, true);
        }
        // Change Output Panel Menu
        if  ( 'trx_sc_layouts' == $sc && 'panel-menu' == $atts['type'] ) {
            trx_addons_add_inline_html($output);
            return '';
        }

        return $output;
    }
}

// Add parameter to the list controls styles
if ( ! function_exists( 'law_office_skin_filter_get_list_sc_slider_controls_styles' ) ) {
	add_filter( 'trx_addons_filter_get_list_sc_slider_controls_styles', 'law_office_skin_filter_get_list_sc_slider_controls_styles', 10, 2 );
	function law_office_skin_filter_get_list_sc_slider_controls_styles( $list ) {
		$list['light'] = esc_html__( 'Light', 'law-office' );
		$list['alter'] = esc_html__( 'Alter', 'law-office' );
		return $list;
	}
}
// Add parameter to the list controls styles
if ( ! function_exists( 'law_office_skin_filter_get_list_sc_slider_paginations_types' ) ) {
	//add_filter( 'trx_addons_filter_get_list_sc_slider_paginations_types', 'law_office_skin_filter_get_list_sc_slider_paginations_types', 10 );
	add_filter( 'trx_addons_filter_get_list_sc_slider_controls_paginations_types', 'law_office_skin_filter_get_list_sc_slider_paginations_types', 10 );
	function law_office_skin_filter_get_list_sc_slider_paginations_types( $list ) {
		$list['title'] = esc_html__( 'Title', 'law-office' );
		return $list;
	}
}

// Add parameter to the list layouts type
if ( ! function_exists( 'law_office_skin_filter_get_list_sc_layouts_type' ) ) {
    add_filter( 'trx_addons_filter_get_list_sc_layouts_type', 'law_office_skin_filter_get_list_sc_layouts_type', 10, 2 );
    function law_office_skin_filter_get_list_sc_layouts_type( $list ) {
        $list['panel-menu'] = esc_html__( 'Panel Menu', 'law-office' );
        return $list;
    }
}

// Add parameter to the list Extend background
if ( ! function_exists( 'law_office_skin_filter_get_list_sc_content_extra_bg' ) ) {
	add_filter( 'trx_addons_filter_get_list_sc_content_extra_bg', 'law_office_skin_filter_get_list_sc_content_extra_bg', 10, 2 );
	function law_office_skin_filter_get_list_sc_content_extra_bg( $list ) {
		$list['large_left'] = esc_html__( 'Large Left', 'law-office' );
		$list['extra_left'] = esc_html__( 'Extra Left', 'law-office' );
		$list['large_right'] = esc_html__( 'Large Right', 'law-office' );
		return $list;
	}
}
// Remove 'Bottom' item from list Services
if ( ! function_exists( 'law_office_skin_filter_get_list_sc_services_featured_positions' ) ) {
    add_filter( 'trx_addons_filter_get_list_sc_services_featured_positions', 'law_office_skin_filter_get_list_sc_services_featured_positions', 10, 2 );
    function law_office_skin_filter_get_list_sc_services_featured_positions( $list ) {
        unset( $list['bottom'] );
        return $list;
    }
}

// Show post link 'Read more' in the blog posts
if ( ! function_exists( 'law_office_show_post_more_link' ) ) {
	function law_office_show_post_more_link( $args = array(), $otag='', $ctag='' ) {
		if ( ! isset( $args['more_button'] ) || $args['more_button'] ) {
			law_office_show_layout(
				'<a class="post-more-link" href="' . esc_url( get_permalink() ) . '"><span class="link-text">'
				. ( ! empty( $args['more_text'] )
					? esc_html( $args['more_text'] )
					: esc_html__( 'Read More', 'law-office' )
				)
				. '</span><span class="more-link-icon"></span></a>',
				$otag,
				$ctag
			);
		}
	}
}

if ( ! function_exists( 'law_office_show_post_more_link' ) ) {
	function law_office_show_post_more_link( $args = array(), $otag='', $ctag='' ) {
		if ( ! isset( $args['more_button'] ) || $args['more_button'] ) {
			law_office_show_layout(
				'<a class="more-link" href="' . esc_url( get_permalink() ) . '">'
				. ( ! empty( $args['more_text'] )
					? esc_html( $args['more_text'] )
					: esc_html__( 'Read more', 'law-office' )
				)
				. '</a>',
				$otag,
				$ctag
			);
		}
	}
}


if (!function_exists('law_office_elm_add_script')) {
	add_filter( 'elementor/frontend/widget/before_render', 'law_office_elm_add_script', 10, 2 );
	function law_office_elm_add_script($content, $widget=null) {
			$setting_class = $content->get_settings('_css_classes');
			if($setting_class == 'VanillaTiltHover') {
				wp_enqueue_script('tilt', law_office_get_file_url('js/tilt/vanilla-tilt.min.js'), array('jquery'), null, true);
			}
		return $content;
	}
}

// Add default prefix in Blogger toggle filter
if (!function_exists('law_office_localize_scripts_skin')) {
    add_filter( 'law_office_filter_localize_script', 'law_office_localize_scripts_skin', 2 );
    function law_office_localize_scripts_skin($arg) {
        $arg['toggle_title'] = esc_html__( "Filter by ", 'law-office' );
        return $arg;
    }
}



// Add cat_sep in meta single
if (!function_exists('law_office_filter_post_meta_args_single')) {
	add_filter( 'law_office_filter_post_meta_args', 'law_office_filter_post_meta_args_single', 2, 2 );
	function law_office_filter_post_meta_args_single($arg, $type) {
		if('single' == $type)
			$arg['cat_sep'] = false;
		return $arg;
	}
}




// cpt_team -> wrap contact form fns info des
if ( !function_exists( 'law_office_cpt_team_contact_form_after_article_before' ) ) {
	add_action('trx_addons_action_after_article', 'law_office_cpt_team_contact_form_after_article_before', 49, 2);
	function law_office_cpt_team_contact_form_after_article_before( $mode, $out='' ) {
		if ($mode == 'team.single') {
			$class = "comments_close";
			if ( comments_open() || get_comments_number() ) {
				$class = "comments_open";
			}
			law_office_show_layout('<section class="team_page_wrap_info '.esc_attr($class).'"><div class="team_page_wrap_info_over">'.$out);
		}
	}
}
if ( !function_exists( 'law_office_cpt_team_contact_form_after_article_after' ) ) {
	add_action('trx_addons_action_after_article', 'law_office_cpt_team_contact_form_after_article_after', 51, 1);
	function law_office_cpt_team_contact_form_after_article_after( $mode ) {
		if ($mode == 'team.single') {
			echo '</div></section>';
		}
	}
}
if ( !function_exists( 'law_office_cpt_team_contact_form_posts_title' ) ) {
	add_filter('trx_addons_filter_team_posts_title', 'law_office_cpt_team_contact_form_posts_title');
	function law_office_cpt_team_contact_form_posts_title() {
		return esc_html__( "Contact", 'law-office' );
	}
}

// Return tag SVG from specified file
if (!function_exists('law_office_get_svg_from_file')) {
	function law_office_get_svg_from_file($svg) {
		$content = law_office_fgc($svg);
		preg_match("#<\s*?svg\b[^>]*>(.*?)</svg\b[^>]*>#s", $content, $matches);
		return !empty($matches[0]) ? str_replace(array("\r", "\n"), array('', ' '), $matches[0]) : '';
	}
}

// Modified Scroll To Top
if (!function_exists('law_office_skin_filter_scroll_to_top')) {
    add_filter('trx_addons_filter_scroll_to_top', 'law_office_skin_filter_scroll_to_top');
    function law_office_skin_filter_scroll_to_top( $output ) {
        if ( law_office_get_theme_option( 'scroll_to_top_style') == 'modern' )  {
            $output = '<a href="#" class="trx_addons_scroll_to_top scroll_to_top_style_' . esc_attr(law_office_get_theme_option( 'scroll_to_top_style')) . esc_attr(law_office_is_on(law_office_get_theme_option('scroll_to_top_scheme_watchers')) ? ' watch_scheme' : '') . '" title="' . esc_attr__('Scroll to top', 'law-office') . '">'
                      . '<span class="scroll_to_top_text">' . esc_html__('Go To Top', 'law-office') . '</span>'
                      . '<span class="scroll_to_top_icon"></span>'
                      . '</a>';

        } else {
            $output = '<a href="#" class="trx_addons_scroll_to_top trx_addons_icon-up scroll_to_top_style_' . esc_attr(law_office_get_theme_option( 'scroll_to_top_style')) . '" title="' . esc_attr__('Scroll to top', 'law-office') . '">'
                      . ( ! empty( $type )
                          ? '<span class="trx_addons_scroll_progress trx_addons_scroll_progress_type_' . esc_attr( $type ) . '"></span>'
                          : ''
                        )
                      . '</a>';
        }
        return $output;
    }
}

// Add sticky socials
if ( !function_exists( 'law_office_skin_wp_footer' ) ) {
    add_action('wp_footer', 'law_office_skin_wp_footer');
    function law_office_skin_wp_footer() {

        // Add sticky socials
        if (( law_office_exists_trx_addons() && trx_addons_get_socials_links() != '') && law_office_is_on( law_office_get_theme_option( 'sticky_socials' ) ) ) {

            $wrap_start = '<div class="sticky_socials_wrap sticky_socials_' . esc_attr( law_office_get_theme_option( 'sticky_socials_style' ) ) . esc_attr( law_office_is_on( law_office_get_theme_option( 'sticky_socials_scheme_watchers' ) ) ? ' watch_scheme' : '') . '">';
            $wrap_end   = '</div>';

            if ( law_office_get_theme_option( 'sticky_socials_style' ) == 'modern' ) {
                // Social icons
                law_office_show_layout(trx_addons_get_socials_links($style = 'icons', $show = 'icons_names'),
                    $wrap_start, $wrap_end);
            } else {
                law_office_show_layout(trx_addons_get_socials_links($style = 'icons', $show = 'icons'),
                    $wrap_start, $wrap_end);
            }
        }

        // Add sticky banner
        if ( law_office_exists_trx_addons() && !empty( law_office_get_theme_option( 'sticky_banner_image' ) ) && law_office_is_on( law_office_get_theme_option( 'sticky_banner' ) ) ) {

            $banner_link = law_office_get_theme_option( 'sticky_banner_link' );

            law_office_show_layout(
                '<div class="sticky-banner_wrap">'
                    . ( !empty( $banner_link ) ? sprintf( '<a href="%s" rel="bookmark">', esc_url( $banner_link ) ) : '')
                    . '<img class="sticky-banner_image" src="' . esc_url( law_office_get_theme_option( 'sticky_banner_image' ) ) . '">'
                    . ( !empty( $banner_link ) ? '</a>' : '' )
                . '</div>'
            );
        }

    }
}


// Detect blog mode 404
if (!function_exists('law_office_filter_detect_blog_mode_404')) {
	add_filter( 'law_office_filter_detect_blog_mode', 'law_office_filter_detect_blog_mode_404' );
	function law_office_filter_detect_blog_mode_404($mode) {
		return is_404() ? '404' : $mode;
	}
}

// TweenMax library for 404
if (!function_exists('trx_addons_filter_load_tweenmax_404')) {
	add_filter('trx_addons_filter_load_tweenmax', 'trx_addons_filter_load_tweenmax_404');
	function trx_addons_filter_load_tweenmax_404($status) {
		return is_404() ? true : $status;
	}
}
// Add single portfolio navigation
if ( !function_exists( 'law_office_single_portfolio_navigation' ) ) {
    add_filter('trx_addons_action_after_article', 'law_office_single_portfolio_navigation');
    function law_office_single_portfolio_navigation( $args ) {
        if( law_office_get_theme_option( 'cpt_navigation_portfolio' ) && 'portfolio.single' == $args ) {
            $post_nav = get_the_post_navigation( array(
                'next_text' => '<span class="meta-nav" aria-hidden="true">' . esc_html__('Next Project', 'law-office') . '</span> ',
                'prev_text' => '<span class="meta-nav" aria-hidden="true">' . esc_html__('Prev Project', 'law-office') . '</span> ',
            ) );
            law_office_show_layout($post_nav);
        }
    }
}
// Display begin of the slider layout for some shortcodes
if (!function_exists('law_office_skin_filter_sc_show_slider_args')) {
    add_filter( 'trx_addons_filter_sc_show_slider_args', 'law_office_skin_filter_sc_show_slider_args' );
    function law_office_skin_filter_sc_show_slider_args( $args = array() ) {
        if ('sc_events' == $args['sc']) {
            $args['args']['slides_min_width'] = 220;
        }
        if ('sc_portfolio' == $args['sc']) {
            $args['args']['slides_min_width'] = 220;
        }
        return  $args;
    }
}

// Remove input hover effects
if ( !function_exists( 'law_office_skin_filter_get_list_input_hover' ) ) {
    add_filter( 'trx_addons_filter_get_list_input_hover', 'law_office_skin_filter_get_list_input_hover');
    function law_office_skin_filter_get_list_input_hover($list) {
        unset($list['accent']);
        unset($list['path']);
        unset($list['jump']);
        unset($list['underline']);
        unset($list['iconed']);
        return $list;
    }
}

// Add new image's hovers
if ( ! function_exists( 'law_office_skin_filter_get_list_hovers' ) ) {
	add_filter(	'law_office_filter_list_hovers', 'law_office_skin_filter_get_list_hovers' );
	function law_office_skin_filter_get_list_hovers( $list ) {
		$list['link'] = esc_html__( 'Link', 'law-office' );
		return $list;
	}
}

// New Functions
//--------------------------------------------------
if ( ! function_exists( 'law_office_skin_theme_specific_setup9' ) ) {
    add_action( 'after_setup_theme', 'law_office_skin_theme_specific_setup9', 9 );
    function law_office_skin_theme_specific_setup9() {
        if ( law_office_exists_trx_addons() ) {
            remove_action( 'trx_addons_action_before_single_post_video', 'trx_addons_cpt_post_before_video_sticky' );
        }
    }
}
// Open wrapper around single post video
if (!function_exists('law_office_skin_trx_addons_cpt_post_before_video_sticky')) {
    add_action( 'trx_addons_action_before_single_post_video', 'law_office_skin_trx_addons_cpt_post_before_video_sticky', 10, 1 );
    function law_office_skin_trx_addons_cpt_post_before_video_sticky( $args = array() ) {
        if ( ! empty( $args['singular'] ) || ! empty( $args['singular_extra'] ) ) {
            $post_meta = get_post_meta( get_the_ID(), 'trx_addons_options', true );
            if ( ! empty( $post_meta['video_sticky'] ) ) {
                ?>
                <div class="trx_addons_video_sticky">
                <div class="trx_addons_video_sticky_inner">
                <h5 class="trx_addons_video_sticky_title">
                    <?php echo esc_html(get_the_title(get_the_ID())); ?></h5>
                <?php
                $GLOBALS['TRX_ADDONS_STORAGE']['video_sticky_opened'] = true;
            }

        }
    }
}