<?php
/**
 * The template to display Admin notices
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0.1
 */

$law_office_theme_slug = get_option( 'template' );
$law_office_theme_obj  = wp_get_theme( $law_office_theme_slug );
?>
<div class="law_office_admin_notice law_office_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$law_office_theme_img = law_office_get_file_url( 'screenshot.jpg' );
	if ( '' != $law_office_theme_img ) {
		?>
		<div class="law_office_notice_image"><img src="<?php echo esc_url( $law_office_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'law-office' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="law_office_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'law-office' ),
				$law_office_theme_obj->get( 'Name' ) . ( LAW_OFFICE_THEME_FREE ? ' ' . __( 'Free', 'law-office' ) : '' ),
				$law_office_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="law_office_notice_text">
		<p class="law_office_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $law_office_theme_obj->description ) );
			?>
		</p>
		<p class="law_office_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'law-office' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="law_office_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=law_office_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'law-office' );
			?>
		</a>
	</div>
</div>
