<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

$law_office_template_args = get_query_var( 'law_office_template_args' );

if ( is_array( $law_office_template_args ) ) {
	$law_office_columns    = empty( $law_office_template_args['columns'] ) ? 2 : max( 1, $law_office_template_args['columns'] );
	$law_office_blog_style = array( $law_office_template_args['type'], $law_office_columns );
    $law_office_columns_class = law_office_get_column_class( 1, $law_office_columns, ! empty( $law_office_template_args['columns_tablet']) ? $law_office_template_args['columns_tablet'] : '', ! empty($law_office_template_args['columns_mobile']) ? $law_office_template_args['columns_mobile'] : '' );
} else {
	$law_office_blog_style = explode( '_', law_office_get_theme_option( 'blog_style' ) );
	$law_office_columns    = empty( $law_office_blog_style[1] ) ? 2 : max( 1, $law_office_blog_style[1] );
    $law_office_columns_class = law_office_get_column_class( 1, $law_office_columns );
}
$law_office_expanded   = ! law_office_sidebar_present() && law_office_get_theme_option( 'expand_content' ) == 'expand';

$law_office_post_format = get_post_format();
$law_office_post_format = empty( $law_office_post_format ) ? 'standard' : str_replace( 'post-format-', '', $law_office_post_format );

?><div class="<?php
	if ( ! empty( $law_office_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( law_office_is_blog_style_use_masonry( $law_office_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $law_office_columns ) : esc_attr( $law_office_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $law_office_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $law_office_columns )
				. ' post_layout_' . esc_attr( $law_office_blog_style[0] )
				. ' post_layout_' . esc_attr( $law_office_blog_style[0] ) . '_' . esc_attr( $law_office_columns )
	);
	law_office_add_blog_animation( $law_office_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$law_office_hover      = ! empty( $law_office_template_args['hover'] ) && ! law_office_is_inherit( $law_office_template_args['hover'] )
							? $law_office_template_args['hover']
							: law_office_get_theme_option( 'image_hover' );

	$law_office_components = ! empty( $law_office_template_args['meta_parts'] )
							? ( is_array( $law_office_template_args['meta_parts'] )
								? $law_office_template_args['meta_parts']
								: explode( ',', $law_office_template_args['meta_parts'] )
								)
							: law_office_array_get_keys_by_value( law_office_get_theme_option( 'meta_parts' ) );

	law_office_show_post_featured( apply_filters( 'law_office_filter_args_featured',
		array(
			'thumb_size' => ! empty( $law_office_template_args['thumb_size'] )
				? $law_office_template_args['thumb_size']
				: law_office_get_thumb_size(
					'classic' == $law_office_blog_style[0]
						? ( strpos( law_office_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $law_office_columns > 2 ? 'big' : 'huge' )
								: ( $law_office_columns > 2
									? ( $law_office_expanded ? 'square' : 'square' )
									: ($law_office_columns > 1 ? 'square' : ( $law_office_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( law_office_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $law_office_columns > 2 ? 'masonry-big' : 'full' )
								: ($law_office_columns === 1 ? ( $law_office_expanded ? 'huge' : 'big' ) : ( $law_office_columns <= 2 && $law_office_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $law_office_hover,
			'meta_parts' => $law_office_components,
			'no_links'   => ! empty( $law_office_template_args['no_links'] ),
        ),
        'content-classic',
        $law_office_template_args
    ) );

	// Title and post meta
	$law_office_show_title = get_the_title() != '';
	$law_office_show_meta  = count( $law_office_components ) > 0 && ! in_array( $law_office_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $law_office_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'law_office_filter_show_blog_meta', $law_office_show_meta, $law_office_components, 'classic' ) ) {
				if ( count( $law_office_components ) > 0 ) {
					do_action( 'law_office_action_before_post_meta' );
					law_office_show_post_meta(
						apply_filters(
							'law_office_filter_post_meta_args', array(
							'components' => join( ',', $law_office_components ),
							'seo'        => false,
							'echo'       => true,
						), $law_office_blog_style[0], $law_office_columns
						)
					);
					do_action( 'law_office_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'law_office_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'law_office_action_before_post_title' );
				if ( empty( $law_office_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'law_office_action_after_post_title' );
			}

			if( !in_array( $law_office_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'law_office_filter_show_blog_readmore', ! $law_office_show_title || ! empty( $law_office_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $law_office_template_args['no_links'] ) ) {
						do_action( 'law_office_action_before_post_readmore' );
						law_office_show_post_more_link( $law_office_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'law_office_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $law_office_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('law_office_filter_show_blog_excerpt', empty($law_office_template_args['hide_excerpt']) && law_office_get_theme_option('excerpt_length') > 0, 'classic')) {
			law_office_show_post_content($law_office_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $law_office_template_args['more_button'] )) {
			if ( empty( $law_office_template_args['no_links'] ) ) {
				do_action( 'law_office_action_before_post_readmore' );
				law_office_show_post_more_link( $law_office_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'law_office_action_after_post_readmore' );
			}
		}
		$law_office_content = ob_get_contents();
		ob_end_clean();
		law_office_show_layout($law_office_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
