<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0.50
 */

$law_office_template_args = get_query_var( 'law_office_template_args' );
if ( is_array( $law_office_template_args ) ) {
	$law_office_columns    = empty( $law_office_template_args['columns'] ) ? 2 : max( 1, $law_office_template_args['columns'] );
	$law_office_blog_style = array( $law_office_template_args['type'], $law_office_columns );
} else {
	$law_office_blog_style = explode( '_', law_office_get_theme_option( 'blog_style' ) );
	$law_office_columns    = empty( $law_office_blog_style[1] ) ? 2 : max( 1, $law_office_blog_style[1] );
}
$law_office_blog_id       = law_office_get_custom_blog_id( join( '_', $law_office_blog_style ) );
$law_office_blog_style[0] = str_replace( 'blog-custom-', '', $law_office_blog_style[0] );
$law_office_expanded      = ! law_office_sidebar_present() && law_office_get_theme_option( 'expand_content' ) == 'expand';
$law_office_components    = ! empty( $law_office_template_args['meta_parts'] )
							? ( is_array( $law_office_template_args['meta_parts'] )
								? join( ',', $law_office_template_args['meta_parts'] )
								: $law_office_template_args['meta_parts']
								)
							: law_office_array_get_keys_by_value( law_office_get_theme_option( 'meta_parts' ) );
$law_office_post_format   = get_post_format();
$law_office_post_format   = empty( $law_office_post_format ) ? 'standard' : str_replace( 'post-format-', '', $law_office_post_format );

$law_office_blog_meta     = law_office_get_custom_layout_meta( $law_office_blog_id );
$law_office_custom_style  = ! empty( $law_office_blog_meta['scripts_required'] ) ? $law_office_blog_meta['scripts_required'] : 'none';

if ( ! empty( $law_office_template_args['slider'] ) || $law_office_columns > 1 || ! law_office_is_off( $law_office_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $law_office_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( law_office_is_off( $law_office_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $law_office_custom_style ) ) . "-1_{$law_office_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $law_office_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $law_office_columns )
					. ' post_layout_' . esc_attr( $law_office_blog_style[0] )
					. ' post_layout_' . esc_attr( $law_office_blog_style[0] ) . '_' . esc_attr( $law_office_columns )
					. ( ! law_office_is_off( $law_office_custom_style )
						? ' post_layout_' . esc_attr( $law_office_custom_style )
							. ' post_layout_' . esc_attr( $law_office_custom_style ) . '_' . esc_attr( $law_office_columns )
						: ''
						)
		);
	law_office_add_blog_animation( $law_office_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'law_office_action_show_layout', $law_office_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $law_office_template_args['slider'] ) || $law_office_columns > 1 || ! law_office_is_off( $law_office_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
