<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

$law_office_template_args = get_query_var( 'law_office_template_args' );
$law_office_columns = 1;
if ( is_array( $law_office_template_args ) ) {
	$law_office_columns    = empty( $law_office_template_args['columns'] ) ? 1 : max( 1, $law_office_template_args['columns'] );
	$law_office_blog_style = array( $law_office_template_args['type'], $law_office_columns );
	if ( ! empty( $law_office_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $law_office_columns > 1 ) {
	    $law_office_columns_class = law_office_get_column_class( 1, $law_office_columns, ! empty( $law_office_template_args['columns_tablet']) ? $law_office_template_args['columns_tablet'] : '', ! empty($law_office_template_args['columns_mobile']) ? $law_office_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $law_office_columns_class ); ?>">
		<?php
	}
}
$law_office_expanded    = ! law_office_sidebar_present() && law_office_get_theme_option( 'expand_content' ) == 'expand';
$law_office_post_format = get_post_format();
$law_office_post_format = empty( $law_office_post_format ) ? 'standard' : str_replace( 'post-format-', '', $law_office_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $law_office_post_format ) );
	law_office_add_blog_animation( $law_office_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$law_office_hover      = ! empty( $law_office_template_args['hover'] ) && ! law_office_is_inherit( $law_office_template_args['hover'] )
							? $law_office_template_args['hover']
							: law_office_get_theme_option( 'image_hover' );
	$law_office_components = ! empty( $law_office_template_args['meta_parts'] )
							? ( is_array( $law_office_template_args['meta_parts'] )
								? $law_office_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $law_office_template_args['meta_parts'] ) )
								)
							: law_office_array_get_keys_by_value( law_office_get_theme_option( 'meta_parts' ) );
	law_office_show_post_featured( apply_filters( 'law_office_filter_args_featured',
		array(
			'no_links'   => ! empty( $law_office_template_args['no_links'] ),
			'hover'      => $law_office_hover,
			'meta_parts' => $law_office_components,
			'thumb_size' => ! empty( $law_office_template_args['thumb_size'] )
							? $law_office_template_args['thumb_size']
							: law_office_get_thumb_size( strpos( law_office_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $law_office_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$law_office_template_args
	) );

	// Title and post meta
	$law_office_show_title = get_the_title() != '';
	$law_office_show_meta  = count( $law_office_components ) > 0 && ! in_array( $law_office_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $law_office_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'law_office_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'law_office_action_before_post_title' );
				if ( empty( $law_office_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'law_office_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'law_office_filter_show_blog_excerpt', empty( $law_office_template_args['hide_excerpt'] ) && law_office_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'law_office_filter_show_blog_meta', $law_office_show_meta, $law_office_components, 'excerpt' ) ) {
				if ( count( $law_office_components ) > 0 ) {
					do_action( 'law_office_action_before_post_meta' );
					law_office_show_post_meta(
						apply_filters(
							'law_office_filter_post_meta_args', array(
								'components' => join( ',', $law_office_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'law_office_action_after_post_meta' );
				}
			}

			if ( law_office_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'law_office_action_before_full_post_content' );
					the_content( '' );
					do_action( 'law_office_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'law-office' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'law-office' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				law_office_show_post_content( $law_office_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'law_office_filter_show_blog_readmore',  ! isset( $law_office_template_args['more_button'] ) || ! empty( $law_office_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $law_office_template_args['no_links'] ) ) {
					do_action( 'law_office_action_before_post_readmore' );
					if ( law_office_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						law_office_show_post_more_link( $law_office_template_args, '<p>', '</p>' );
					} else {
						law_office_show_post_comments_link( $law_office_template_args, '<p>', '</p>' );
					}
					do_action( 'law_office_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $law_office_template_args ) ) {
	if ( ! empty( $law_office_template_args['slider'] ) || $law_office_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
