<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

$law_office_template_args = get_query_var( 'law_office_template_args' );
if ( is_array( $law_office_template_args ) ) {
	$law_office_columns    = empty( $law_office_template_args['columns'] ) ? 2 : max( 1, $law_office_template_args['columns'] );
	$law_office_blog_style = array( $law_office_template_args['type'], $law_office_columns );
    $law_office_columns_class = law_office_get_column_class( 1, $law_office_columns, ! empty( $law_office_template_args['columns_tablet']) ? $law_office_template_args['columns_tablet'] : '', ! empty($law_office_template_args['columns_mobile']) ? $law_office_template_args['columns_mobile'] : '' );
} else {
	$law_office_blog_style = explode( '_', law_office_get_theme_option( 'blog_style' ) );
	$law_office_columns    = empty( $law_office_blog_style[1] ) ? 2 : max( 1, $law_office_blog_style[1] );
    $law_office_columns_class = law_office_get_column_class( 1, $law_office_columns );
}

$law_office_post_format = get_post_format();
$law_office_post_format = empty( $law_office_post_format ) ? 'standard' : str_replace( 'post-format-', '', $law_office_post_format );

?><div class="
<?php
if ( ! empty( $law_office_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( law_office_is_blog_style_use_masonry( $law_office_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $law_office_columns ) : esc_attr( $law_office_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $law_office_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $law_office_columns )
		. ( 'portfolio' != $law_office_blog_style[0] ? ' ' . esc_attr( $law_office_blog_style[0] )  . '_' . esc_attr( $law_office_columns ) : '' )
	);
	law_office_add_blog_animation( $law_office_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$law_office_hover   = ! empty( $law_office_template_args['hover'] ) && ! law_office_is_inherit( $law_office_template_args['hover'] )
								? $law_office_template_args['hover']
								: law_office_get_theme_option( 'image_hover' );

	if ( 'dots' == $law_office_hover ) {
		$law_office_post_link = empty( $law_office_template_args['no_links'] )
								? ( ! empty( $law_office_template_args['link'] )
									? $law_office_template_args['link']
									: get_permalink()
									)
								: '';
		$law_office_target    = ! empty( $law_office_post_link ) && false === strpos( $law_office_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$law_office_components = ! empty( $law_office_template_args['meta_parts'] )
							? ( is_array( $law_office_template_args['meta_parts'] )
								? $law_office_template_args['meta_parts']
								: explode( ',', $law_office_template_args['meta_parts'] )
								)
							: law_office_array_get_keys_by_value( law_office_get_theme_option( 'meta_parts' ) );

	// Featured image
	law_office_show_post_featured( apply_filters( 'law_office_filter_args_featured',
        array(
			'hover'         => $law_office_hover,
			'no_links'      => ! empty( $law_office_template_args['no_links'] ),
			'thumb_size'    => ! empty( $law_office_template_args['thumb_size'] )
								? $law_office_template_args['thumb_size']
								: law_office_get_thumb_size(
									law_office_is_blog_style_use_masonry( $law_office_blog_style[0] )
										? (	strpos( law_office_get_theme_option( 'body_style' ), 'full' ) !== false || $law_office_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( law_office_get_theme_option( 'body_style' ), 'full' ) !== false || $law_office_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => law_office_is_blog_style_use_masonry( $law_office_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $law_office_components,
			'class'         => 'dots' == $law_office_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $law_office_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $law_office_post_link )
												? '<a href="' . esc_url( $law_office_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $law_office_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $law_office_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $law_office_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!