<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$law_office_copyright_scheme = law_office_get_theme_option( 'copyright_scheme' );
if ( ! empty( $law_office_copyright_scheme ) && ! law_office_is_inherit( $law_office_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $law_office_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$law_office_copyright = law_office_get_theme_option( 'copyright' );
			if ( ! empty( $law_office_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$law_office_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $law_office_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$law_office_copyright = law_office_prepare_macros( $law_office_copyright );
				// Display copyright
				echo wp_kses( nl2br( $law_office_copyright ), 'law_office_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
