<?php
/**
 * The template to display default site footer
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0.10
 */

$law_office_footer_id = law_office_get_custom_footer_id();
$law_office_footer_meta = get_post_meta( $law_office_footer_id, 'trx_addons_options', true );
if ( ! empty( $law_office_footer_meta['margin'] ) ) {
	law_office_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( law_office_prepare_css_value( $law_office_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $law_office_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $law_office_footer_id ) ) ); ?>
						<?php
						$law_office_footer_scheme = law_office_get_theme_option( 'footer_scheme' );
						if ( ! empty( $law_office_footer_scheme ) && ! law_office_is_inherit( $law_office_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $law_office_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'law_office_action_show_layout', $law_office_footer_id );
	?>
</footer><!-- /.footer_wrap -->
