<?php
/**
 * The template to display the site logo in the footer
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0.10
 */

// Logo
if ( law_office_is_on( law_office_get_theme_option( 'logo_in_footer' ) ) ) {
	$law_office_logo_image = law_office_get_logo_image( 'footer' );
	$law_office_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $law_office_logo_image['logo'] ) || ! empty( $law_office_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $law_office_logo_image['logo'] ) ) {
					$law_office_attr = law_office_getimagesize( $law_office_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $law_office_logo_image['logo'] ) . '"'
								. ( ! empty( $law_office_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $law_office_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'law-office' ) . '"'
								. ( ! empty( $law_office_attr[3] ) ? ' ' . wp_kses_data( $law_office_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $law_office_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $law_office_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
