<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0.10
 */

// Footer sidebar
$law_office_footer_name    = law_office_get_theme_option( 'footer_widgets' );
$law_office_footer_present = ! law_office_is_off( $law_office_footer_name ) && is_active_sidebar( $law_office_footer_name );
if ( $law_office_footer_present ) {
	law_office_storage_set( 'current_sidebar', 'footer' );
	$law_office_footer_wide = law_office_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $law_office_footer_name ) ) {
		dynamic_sidebar( $law_office_footer_name );
	}
	$law_office_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $law_office_out ) ) {
		$law_office_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $law_office_out );
		$law_office_need_columns = true;   //or check: strpos($law_office_out, 'columns_wrap')===false;
		if ( $law_office_need_columns ) {
			$law_office_columns = max( 0, (int) law_office_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $law_office_columns ) {
				$law_office_columns = min( 4, max( 1, law_office_tags_count( $law_office_out, 'aside' ) ) );
			}
			if ( $law_office_columns > 1 ) {
				$law_office_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $law_office_columns ) . ' widget', $law_office_out );
			} else {
				$law_office_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $law_office_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'law_office_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $law_office_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $law_office_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'law_office_action_before_sidebar', 'footer' );
				law_office_show_layout( $law_office_out );
				do_action( 'law_office_action_after_sidebar', 'footer' );
				if ( $law_office_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $law_office_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'law_office_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
