<?php
/**
 * The template to display default site header
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

$law_office_header_css   = '';
$law_office_header_image = get_header_image();
$law_office_header_video = law_office_get_header_video();
if ( ! empty( $law_office_header_image ) && law_office_trx_addons_featured_image_override( is_singular() || law_office_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$law_office_header_image = law_office_get_current_mode_image( $law_office_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $law_office_header_image ) || ! empty( $law_office_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $law_office_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $law_office_header_image ) {
		echo ' ' . esc_attr( law_office_add_inline_css_class( 'background-image: url(' . esc_url( $law_office_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( law_office_is_on( law_office_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight law-office-full-height';
	}
	$law_office_header_scheme = law_office_get_theme_option( 'header_scheme' );
	if ( ! empty( $law_office_header_scheme ) && ! law_office_is_inherit( $law_office_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $law_office_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $law_office_header_video ) ) {
		get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( law_office_is_on( law_office_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'law_office_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
