<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

$law_office_args = get_query_var( 'law_office_logo_args' );

// Site logo
$law_office_logo_type   = isset( $law_office_args['type'] ) ? $law_office_args['type'] : '';
$law_office_logo_image  = law_office_get_logo_image( $law_office_logo_type );
$law_office_logo_text   = law_office_is_on( law_office_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$law_office_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $law_office_logo_image['logo'] ) || ! empty( $law_office_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $law_office_logo_image['logo'] ) ) {
			if ( empty( $law_office_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($law_office_logo_image['logo']) && (int) $law_office_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$law_office_attr = law_office_getimagesize( $law_office_logo_image['logo'] );
				echo '<img src="' . esc_url( $law_office_logo_image['logo'] ) . '"'
						. ( ! empty( $law_office_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $law_office_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $law_office_logo_text ) . '"'
						. ( ! empty( $law_office_attr[3] ) ? ' ' . wp_kses_data( $law_office_attr[3] ) : '' )
						. '>';
			}
		} else {
			law_office_show_layout( law_office_prepare_macros( $law_office_logo_text ), '<span class="logo_text">', '</span>' );
			law_office_show_layout( law_office_prepare_macros( $law_office_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
