<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

// Page (category, tag, archive, author) title

if ( law_office_need_page_title() ) {
	law_office_sc_layouts_showed( 'title', true );
	law_office_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								law_office_show_post_meta(
									apply_filters(
										'law_office_filter_post_meta_args', array(
											'components' => join( ',', law_office_array_get_keys_by_value( law_office_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', law_office_array_get_keys_by_value( law_office_get_theme_option( 'counters' ) ) ),
											'seo'        => law_office_is_on( law_office_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$law_office_blog_title           = law_office_get_blog_title();
							$law_office_blog_title_text      = '';
							$law_office_blog_title_class     = '';
							$law_office_blog_title_link      = '';
							$law_office_blog_title_link_text = '';
							if ( is_array( $law_office_blog_title ) ) {
								$law_office_blog_title_text      = $law_office_blog_title['text'];
								$law_office_blog_title_class     = ! empty( $law_office_blog_title['class'] ) ? ' ' . $law_office_blog_title['class'] : '';
								$law_office_blog_title_link      = ! empty( $law_office_blog_title['link'] ) ? $law_office_blog_title['link'] : '';
								$law_office_blog_title_link_text = ! empty( $law_office_blog_title['link_text'] ) ? $law_office_blog_title['link_text'] : '';
							} else {
								$law_office_blog_title_text = $law_office_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $law_office_blog_title_class ); ?>">
								<?php
								$law_office_top_icon = law_office_get_term_image_small();
								if ( ! empty( $law_office_top_icon ) ) {
									$law_office_attr = law_office_getimagesize( $law_office_top_icon );
									?>
									<img src="<?php echo esc_url( $law_office_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'law-office' ); ?>"
										<?php
										if ( ! empty( $law_office_attr[3] ) ) {
											law_office_show_layout( $law_office_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $law_office_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $law_office_blog_title_link ) && ! empty( $law_office_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $law_office_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $law_office_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'law_office_action_breadcrumbs' );
						$law_office_breadcrumbs = ob_get_contents();
						ob_end_clean();
						law_office_show_layout( $law_office_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
