<?php
/**
 * The template to display the widgets area in the header
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

// Header sidebar
$law_office_header_name    = law_office_get_theme_option( 'header_widgets' );
$law_office_header_present = ! law_office_is_off( $law_office_header_name ) && is_active_sidebar( $law_office_header_name );
if ( $law_office_header_present ) {
	law_office_storage_set( 'current_sidebar', 'header' );
	$law_office_header_wide = law_office_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $law_office_header_name ) ) {
		dynamic_sidebar( $law_office_header_name );
	}
	$law_office_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $law_office_widgets_output ) ) {
		$law_office_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $law_office_widgets_output );
		$law_office_need_columns   = strpos( $law_office_widgets_output, 'columns_wrap' ) === false;
		if ( $law_office_need_columns ) {
			$law_office_columns = max( 0, (int) law_office_get_theme_option( 'header_columns' ) );
			if ( 0 == $law_office_columns ) {
				$law_office_columns = min( 6, max( 1, law_office_tags_count( $law_office_widgets_output, 'aside' ) ) );
			}
			if ( $law_office_columns > 1 ) {
				$law_office_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $law_office_columns ) . ' widget', $law_office_widgets_output );
			} else {
				$law_office_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $law_office_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'law_office_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $law_office_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $law_office_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'law_office_action_before_sidebar', 'header' );
				law_office_show_layout( $law_office_widgets_output );
				do_action( 'law_office_action_after_sidebar', 'header' );
				if ( $law_office_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $law_office_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'law_office_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
