<?php
/**
 * The template 'Style 1' to displaying related posts
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0
 */

$law_office_link        = get_permalink();
$law_office_post_format = get_post_format();
$law_office_post_format = empty( $law_office_post_format ) ? 'standard' : str_replace( 'post-format-', '', $law_office_post_format );
?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item post_format_' . esc_attr( $law_office_post_format ) ); ?> data-post-id="<?php the_ID(); ?>">
	<?php
	law_office_show_post_featured(
		array(
			'thumb_size'    => apply_filters( 'law_office_filter_related_thumb_size', law_office_get_thumb_size( (int) law_office_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'big' ) ),
			'post_info'     => '<div class="post_header entry-header">'
									. '<div class="post_categories">' . wp_kses( law_office_get_post_categories( '' ), 'law_office_kses_content' ) . '</div>'
									. '<h6 class="post_title entry-title"><a href="' . esc_url( $law_office_link ) . '">'
										. wp_kses_data( '' == get_the_title() ? esc_html__( '- No title -', 'law-office' ) : get_the_title() )
									. '</a></h6>'
									. ( in_array( get_post_type(), array( 'post', 'attachment' ) )
											? '<div class="post_meta"><a href="' . esc_url( $law_office_link ) . '" class="post_meta_item post_date">' . wp_kses_data( law_office_get_date() ) . '</a></div>'
											: '' )
								. '</div>',
		)
	);
	?>
</div>
