<?php
/**
 * The template to display Admin notices
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.98.0
 */

$law_office_skins_url   = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$law_office_active_skin = law_office_skins_get_active_skin_name();
?>
<div class="law_office_admin_notice law_office_skins_notice notice notice-error">
	<?php
	// Theme image
	$law_office_theme_img = law_office_get_file_url( 'screenshot.jpg' );
	if ( '' != $law_office_theme_img ) {
		?>
		<div class="law_office_notice_image"><img src="<?php echo esc_url( $law_office_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'law-office' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="law_office_notice_title">
		<?php esc_html_e( 'Active skin is missing!', 'law-office' ); ?>
	</h3>
	<div class="law_office_notice_text">
		<p>
			<?php
			// Translators: Add a current skin name to the message
			echo wp_kses_data( sprintf( __( "Your active skin <b>'%s'</b> is missing. Usually this happens when the theme is updated directly through the server or FTP.", 'law-office' ), ucfirst( $law_office_active_skin ) ) );
			?>
		</p>
		<p>
			<?php
			echo wp_kses_data( __( "Please use only <b>'ThemeREX Updater v.1.6.0+'</b> plugin for your future updates.", 'law-office' ) );
			?>
		</p>
		<p>
			<?php
			echo wp_kses_data( __( "But no worries! You can re-download the skin via 'Skins Manager' ( Theme Panel - Theme Dashboard - Skins ).", 'law-office' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="law_office_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $law_office_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'law-office' );
			?>
		</a>
	</div>
</div>
