<?php
/**
 * Information about this theme
 *
 * @package LAW OFFICE
 * @since LAW OFFICE 1.0.30
 */


// Redirect to the 'About Theme' page after switch theme
if ( ! function_exists( 'law_office_about_after_switch_theme' ) ) {
	add_action( 'after_switch_theme', 'law_office_about_after_switch_theme', 1000 );
	function law_office_about_after_switch_theme() {
		update_option( 'law_office_about_page', 1 );
	}
}
if ( ! function_exists( 'law_office_about_after_setup_theme' ) ) {
	add_action( 'init', 'law_office_about_after_setup_theme', 1000 );
	function law_office_about_after_setup_theme() {
		if ( ! defined( 'WP_CLI' ) && get_option( 'law_office_about_page' ) == 1 ) {
			update_option( 'law_office_about_page', 0 );
			wp_safe_redirect( admin_url() . 'themes.php?page=law_office_about' );
			exit();
		} else {
			if ( law_office_get_value_gp( 'page' ) == 'law_office_about' && law_office_exists_trx_addons() ) {
				wp_safe_redirect( admin_url() . 'admin.php?page=trx_addons_theme_panel' );
				exit();
			}
		}
	}
}


// Add 'About Theme' item in the Appearance menu
if ( ! function_exists( 'law_office_about_add_menu_items' ) ) {
	add_action( 'admin_menu', 'law_office_about_add_menu_items' );
	function law_office_about_add_menu_items() {
		if ( ! law_office_exists_trx_addons() ) {
			$theme_slug  = get_template();
			$theme_name  = wp_get_theme( $theme_slug )->get( 'Name' ) . ( LAW_OFFICE_THEME_FREE ? ' ' . esc_html__( 'Free', 'law-office' ) : '' );
			add_theme_page(
				// Translators: Add theme name to the page title
				sprintf( esc_html__( 'About %s', 'law-office' ), $theme_name ),    //page_title
				// Translators: Add theme name to the menu title
				sprintf( esc_html__( 'About %s', 'law-office' ), $theme_name ),    //menu_title
				'manage_options',                                               //capability
				'law_office_about',                                                //menu_slug
				'law_office_about_page_builder'                                    //callback
			);
		}
	}
}


// Load page-specific scripts and styles
if ( ! function_exists( 'law_office_about_enqueue_scripts' ) ) {
	add_action( 'admin_enqueue_scripts', 'law_office_about_enqueue_scripts' );
	function law_office_about_enqueue_scripts() {
		$screen = function_exists( 'get_current_screen' ) ? get_current_screen() : false;
		if ( ! empty( $screen->id ) && false !== strpos( $screen->id, '_page_law_office_about' ) ) {
			// Scripts
			if ( ! law_office_exists_trx_addons() && function_exists( 'law_office_plugins_installer_enqueue_scripts' ) ) {
				law_office_plugins_installer_enqueue_scripts();
			}
			// Styles
			$fdir = law_office_get_file_url( 'theme-specific/theme-about/theme-about.css' );
			if ( '' != $fdir ) {
				wp_enqueue_style( 'law-office-about', $fdir, array(), null );
			}
		}
	}
}


// Build 'About Theme' page
if ( ! function_exists( 'law_office_about_page_builder' ) ) {
	function law_office_about_page_builder() {
		$theme_slug = get_template();
		$theme      = wp_get_theme( $theme_slug );
		?>
		<div class="law_office_about">

			<?php do_action( 'law_office_action_theme_about_start', $theme ); ?>

			<?php do_action( 'law_office_action_theme_about_before_logo', $theme ); ?>

			<div class="law_office_about_logo">
				<?php
				$logo = law_office_get_file_url( 'theme-specific/theme-about/icon.jpg' );
				if ( empty( $logo ) ) {
					$logo = law_office_get_file_url( 'screenshot.jpg' );
				}
				if ( ! empty( $logo ) ) {
					?>
					<img src="<?php echo esc_url( $logo ); ?>">
					<?php
				}
				?>
			</div>

			<?php do_action( 'law_office_action_theme_about_before_title', $theme ); ?>

			<h1 class="law_office_about_title">
			<?php
				echo esc_html(
					sprintf(
						// Translators: Add theme name and version to the 'Welcome' message
						__( 'Welcome to %1$s %2$s v.%3$s', 'law-office' ),
						$theme->get( 'Name' ),
						LAW_OFFICE_THEME_FREE ? __( 'Free', 'law-office' ) : '',
						$theme->get( 'Version' )
					)
				);
			?>
			</h1>

			<?php do_action( 'law_office_action_theme_about_before_description', $theme ); ?>

			<div class="law_office_about_description">
				<p>
					<?php
					echo wp_kses_data( __( 'In order to continue, please install and activate <b>ThemeREX Addons plugin</b>.', 'law-office' ) );
					?>
					<sup>*</sup>
				</p>
			</div>

			<?php do_action( 'law_office_action_theme_about_before_buttons', $theme ); ?>

			<div class="law_office_about_buttons">
				<?php law_office_plugins_installer_get_button_html( 'trx_addons' ); ?>
			</div>

			<?php do_action( 'law_office_action_theme_about_before_buttons', $theme ); ?>

			<div class="law_office_about_notes">
				<p>
					<sup>*</sup>
					<?php
					echo wp_kses_data( __( "<i>ThemeREX Addons plugin</i> will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options.", 'law-office' ) );
					?>
				</p>
			</div>

			<?php do_action( 'law_office_action_theme_about_end', $theme ); ?>

		</div>
		<?php
	}
}


// Hide TGMPA notice on the page 'About Theme'
if ( ! function_exists( 'law_office_about_page_disable_tgmpa_notice' ) ) {
	add_filter( 'tgmpa_show_admin_notice_capability', 'law_office_about_page_disable_tgmpa_notice' );
	function law_office_about_page_disable_tgmpa_notice($cap) {
		if ( law_office_get_value_gp( 'page' ) == 'law_office_about' ) {
			$cap = 'unfiltered_upload';
		}
		return $cap;
	}
}

require_once LAW_OFFICE_THEME_DIR . 'includes/plugins-installer/plugins-installer.php';
